package app.visly.gradle

import app.visly.Visly
import app.visly.VislyError
import app.visly.VislyLog
import org.gradle.api.DefaultTask
import org.gradle.api.tasks.TaskAction

open class CheckVersionTask : DefaultTask() {

    var visly: Visly? = null

    init {
        outputs.upToDateWhen {
            visly?.shouldCheckNewVersion()?.not() ?: true
        }
    }

    @TaskAction
    fun checkNewVersion() {
        try {
            visly?.checkNewVersion()
        } catch (error: Throwable) {
            (error as? VislyError)?.let {
                VislyLog.track(it)
            }
            VislyLog.w("Plugin version check failed.")
        }
    }
}