package app.visly.codegen.util

import java.text.DecimalFormat

enum class VMLUnit {
    px
}

data class VMLDimension(val value: Double, val unit: VMLUnit) {

    val dp: Double get() =
        when (this.unit) {
            VMLUnit.px -> value
        }
}

fun Double.vmlPx(): VMLDimension {
    return VMLDimension(this, VMLUnit.px)
}

// Trim decimals if .00
fun Double.xmlFormatted(): String {
    if (this.toInt().toDouble() == this) {
        return "${this.toInt()}"
    }

    return DecimalFormat("#0.00").format(this)
}