package app.visly.codegen.util

/**
 * Simple file wrapper for better testability
 */
class File private constructor(path: String) {

    private val file = java.io.File(path)

    fun mkdirs() = file.mkdirs()

    fun createNewFile() = file.createNewFile()

    fun exists() = file.exists()

    fun delete() = file.delete()

    fun writeText(text: String) = file.writeText(text)

    companion object {
        fun get(path: String): File = File(path)
    }
}