package app.visly.codegen.util

enum class DensityClass(val density: Double, val identifier: String) {
    MDPI(1.0, "mdpi"),
    HDPI(1.5, "hdpi"),
    XHDPI(2.0, "xhdpi"),
    XXHDPI(3.0, "xxhdpi"),
    XXXHDPI(4.0, "xxxhdpi");

    companion object {
        fun fromDensity(density: Double): DensityClass {
            when (density) {
                DensityClass.MDPI.density -> {
                    return MDPI
                }
                DensityClass.HDPI.density -> {
                    return HDPI
                }
                DensityClass.XHDPI.density -> {
                    return XHDPI
                }
                DensityClass.XXHDPI.density -> {
                    return XXHDPI
                }
                DensityClass.XXXHDPI.density -> {
                    return XXXHDPI
                }
                else -> throw Exception("Unsupported density $density")
            }
        }
    }
}

object DrawableHelper {

    fun drawableFolderForDensity(density: Double): String {
        val densityClass = DensityClass.fromDensity(density)
        return "drawable-${densityClass.identifier}"
    }
}