package app.visly.codegen.color

import app.visly.VislyLog
import app.visly.codegen.AssetGenerator
import app.visly.codegen.AssetUtil
import app.visly.codegen.Release
import app.visly.codegen.util.toValidResourceName
import app.visly.filesystem.VislyFS
import com.commit451.resourcespoet.ResourcesPoet

class ColorsGenerator(private val resDir: String) : AssetGenerator {

    override fun generateAssets(release: Release) {
        VislyFS().mkdirs("$resDir/values")
        VislyFS().writeBytes(
            generateCode(release),
            "$resDir/values/colors.xml"
        )
    }

    private fun generateCode(release: Release): ByteArray {
        val resPoet = ResourcesPoet.create(true)
        release.colors().forEach {
            val name = "${AssetUtil.resource_prefix}${it.name().toValidResourceName()}"
            resPoet.addColor(name, ColorParser.parse(it))
            VislyLog.d("Generated color: $name")
        }

        return resPoet.build().toByteArray(Charsets.UTF_8)
    }
}