package app.visly.codegen

import app.visly.filesystem.VislyFS
import app.visly.io.AssetsQuery

typealias Release = AssetsQuery.ReleaseInfo
typealias Data = AssetsQuery.Data
typealias Team = AssetsQuery.Team

class AssetsGenerator(
    private val projectDir: String,
    private val generators: List<AssetGenerator>
) {

    fun process(release: Release) {
        if (VislyFS().exists(projectDir)) {
            if (!VislyFS().deleteRecursively(projectDir)) {
                throw Throwable("Failed to clean project root dir")
            }
        }

        if (!VislyFS().mkdirs(projectDir)) {
            throw Throwable("Failed to create project root dir")
        }

        generators.forEach { it.generateAssets(release) }
    }
}