package app.visly

private var logger: Logger? = null

object VislyLog {

    private fun logMessage(message: String): String {
        return "Visly: $message"
    }

    fun set(loggerImpl: Logger) {
        logger = loggerImpl
    }

    fun lc(message: String) {
        logger?.lc(logMessage(message))
    }

    fun i(message: String) {
        logger?.i(logMessage(message))
    }

    fun d(message: String) {
        logger?.d(logMessage(message))
    }

    fun w(message: String) {
        logger?.w(logMessage(message))
    }

    fun e(message: String) {
        logger?.e(logMessage(message))
    }

    fun track(event: String) {
        logger?.track(event)
    }

    fun track(error: VislyError) {
        logger?.track(error)
    }
}

interface Logger {
    fun i(message: String)
    fun lc(message: String)
    fun d(message: String)
    fun w(message: String)
    fun e(message: String)
    fun track(event: String)
    fun track(error: VislyError)
}