package app.visly

class VislyError(
    val errorCategory: String,
    val errorCause: String,
    val errorDescription: String,
    val userMessage: String
) : Throwable(userMessage)

object DownloadAssetsError {

    private val CATEGORY = "Download assets"

    fun networkError(description: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "Network error",
            errorDescription = description,
            userMessage = description
        )
    }

    fun graphQlError(description: String, userMessage: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "GraphQl error",
            errorDescription = description,
            userMessage = userMessage
        )
    }
}

object CheckNewVersionError {

    private val CATEGORY = "Check new version"

    fun networkError(description: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "Network error",
            errorDescription = description,
            userMessage = description
        )
    }

    fun graphQlError(description: String, userMessage: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "GraphQl error",
            errorDescription = description,
            userMessage = userMessage
        )
    }
}

object ConfigurationError {

    private val CATEGORY = "Configuration"

    fun noApiKey(description: String, userMessage: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "No api key provided",
            errorDescription = description,
            userMessage = userMessage
        )
    }
}

object CodegenError {

    private val CATEGORY = "Code generation"

    fun iconsError(description: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "Icons generation failed",
            errorDescription = description,
            userMessage = description
        )
    }

    fun textStylesError(description: String, userMessage: String): VislyError {
        return VislyError(
            errorCategory = CATEGORY,
            errorCause = "TextStyles generation failed",
            errorDescription = description,
            userMessage = userMessage
        )
    }
}