/*
 * Decompiled with CFR 0.152.
 */
package app.visly.mixpanel;

import app.visly.Config;
import app.visly.VislyError;
import app.visly.mixpanel.MixpanelUploader;
import com.mixpanel.mixpanelapi.MessageBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/visly/mixpanel/Mixpanel;", "", "token", "", "deviceId", "osVersion", "toolVersion", "uploader", "Lapp/visly/mixpanel/MixpanelUploader;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lapp/visly/mixpanel/MixpanelUploader;)V", "createEvent", "Lorg/json/JSONObject;", "event", "props", "track", "", "error", "Lapp/visly/VislyError;", "visly-gradle-plugin"})
public final class Mixpanel {
    private final String token;
    private final String deviceId;
    private final String osVersion;
    private final String toolVersion;
    private final MixpanelUploader uploader;

    public final void track(@NotNull VislyError error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        JSONObject jSONObject = new JSONObject().put("category", (Object)error.getErrorCategory()).put("cause", (Object)error.getErrorCause()).put("description", (Object)error.getErrorDescription());
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"JSONObject()\n           \u2026, error.errorDescription)");
        this.uploader.send(this.createEvent("Error", jSONObject));
    }

    public final void track(@NotNull String event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.uploader.send(Mixpanel.createEvent$default(this, event, null, 2, null));
    }

    private final JSONObject createEvent(String event, JSONObject props) {
        JSONObject completeProps = props.put("os", (Object)this.osVersion).put("tool_version", (Object)this.toolVersion);
        MessageBuilder messageBuilder = new MessageBuilder(this.token);
        JSONObject jSONObject = messageBuilder.event(this.deviceId, event, completeProps);
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"messageBuilder.event(dev\u2026Id, event, completeProps)");
        return jSONObject;
    }

    static /* synthetic */ JSONObject createEvent$default(Mixpanel mixpanel, String string, JSONObject jSONObject, int n, Object object) {
        if ((n & 2) != 0) {
            jSONObject = new JSONObject();
        }
        return mixpanel.createEvent(string, jSONObject);
    }

    public Mixpanel(@NotNull String token, @NotNull String deviceId, @NotNull String osVersion, @NotNull String toolVersion, @NotNull MixpanelUploader uploader) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        Intrinsics.checkParameterIsNotNull((Object)osVersion, (String)"osVersion");
        Intrinsics.checkParameterIsNotNull((Object)toolVersion, (String)"toolVersion");
        Intrinsics.checkParameterIsNotNull((Object)uploader, (String)"uploader");
        this.token = token;
        this.deviceId = deviceId;
        this.osVersion = osVersion;
        this.toolVersion = toolVersion;
        this.uploader = uploader;
    }

    public /* synthetic */ Mixpanel(String string, String string2, String string3, String string4, MixpanelUploader mixpanelUploader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Config.INSTANCE.getMIXPANEL_TOKEN();
        }
        if ((n & 4) != 0) {
            string3 = SystemUtils.OS_NAME + '-' + SystemUtils.OS_VERSION;
        }
        if ((n & 8) != 0) {
            string4 = Config.INSTANCE.getVERSION();
        }
        if ((n & 0x10) != 0) {
            mixpanelUploader = new MixpanelUploader(null, 1, null);
        }
        this(string, string2, string3, string4, mixpanelUploader);
    }
}

