/*
 * Decompiled with CFR 0.152.
 */
package app.visly.codegen.image;

import app.visly.CodegenError;
import app.visly.VislyLog;
import app.visly.codegen.AssetGenerator;
import app.visly.codegen.image.MediaType;
import app.visly.codegen.image.SVGParser;
import app.visly.codegen.util.DrawableHelper;
import app.visly.codegen.util.StringUtilKt;
import app.visly.filesystem.FileSystem_UtilKt;
import app.visly.io.AssetsQuery;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\n\u001a\u00020\u00062\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/visly/codegen/image/ImagesGenerator;", "Lapp/visly/codegen/AssetGenerator;", "resDir", "", "(Ljava/lang/String;)V", "createFile", "", "data", "", "path", "generateAssets", "release", "Lapp/visly/io/AssetsQuery$ReleaseInfo;", "Lapp/visly/codegen/Release;", "generateImage", "image", "Lapp/visly/io/AssetsQuery$Image;", "generatePngs", "name", "generateVectorDrawable", "visly-gradle-plugin"})
public final class ImagesGenerator
implements AssetGenerator {
    private final String resDir;

    @Override
    public void generateAssets(@NotNull AssetsQuery.ReleaseInfo release) {
        Intrinsics.checkParameterIsNotNull((Object)release, (String)"release");
        FileSystem_UtilKt.VislyFS().mkdirs(this.resDir + "/drawable");
        List<AssetsQuery.Image> list = release.images();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"release.images()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssetsQuery.Image it = (AssetsQuery.Image)element$iv;
            boolean bl = false;
            AssetsQuery.Image image = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it");
            this.generateImage(image);
        }
    }

    private final void generateImage(AssetsQuery.Image image) {
        boolean bl = image.versions().size() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<AssetsQuery.Version> list = image.versions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"image.versions()");
        String string = ((AssetsQuery.Version)CollectionsKt.first(list)).mimetype();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"image.versions().first().mimetype()");
        String mediaType = string;
        StringBuilder stringBuilder = new StringBuilder().append("visly_");
        String string2 = image.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"image.name()");
        String imageName = stringBuilder.append(StringUtilKt.toValidResourceName(string2)).toString();
        String string3 = mediaType;
        if (Intrinsics.areEqual((Object)string3, (Object)MediaType.IMG_SVG_XML.getType())) {
            this.generateVectorDrawable(image, imageName);
            VislyLog.INSTANCE.d("Generated icon: " + imageName);
        } else if (Intrinsics.areEqual((Object)string3, (Object)MediaType.IMG_PNG.getType())) {
            this.generatePngs(image, imageName);
            VislyLog.INSTANCE.d("Generated icon: " + imageName);
        } else {
            throw (Throwable)CodegenError.INSTANCE.iconsError("Image " + image.name() + " uses unsupported media type: " + mediaType + ". Perhaps upgrade Visly plugin?");
        }
    }

    private final void generateVectorDrawable(AssetsQuery.Image image, String name) {
        String data;
        List<AssetsQuery.Version> list = image.versions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"image.versions()");
        String string = ((AssetsQuery.Version)CollectionsKt.first(list)).base64();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"image.versions().first().base64()");
        String svgDataUri = string;
        String string2 = StringUtilKt.dataUrlBase64(svgDataUri);
        if (string2 == null || (string2 = StringUtilKt.base64DecodeString(string2)) == null) {
            throw (Throwable)CodegenError.INSTANCE.iconsError("Could not decode base64 from: " + svgDataUri);
        }
        String svgData = string2;
        SVGParser sVGParser = new SVGParser();
        String string3 = image.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"image.name()");
        String string4 = data = sVGParser.parse(svgData, string3);
        Charset charset = Charsets.UTF_8;
        ImagesGenerator imagesGenerator = this;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string5.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        imagesGenerator.createFile(byArray2, this.resDir + "/drawable/" + name + ".xml");
    }

    private final void generatePngs(AssetsQuery.Image image, String name) {
        for (AssetsQuery.Version version : image.versions()) {
            Object object;
            block6: {
                String pngDataUri;
                block5: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)version.base64(), (String)"version.base64()");
                    object = StringUtilKt.dataUrlBase64(pngDataUri);
                    if (object == null) break block5;
                    byte[] byArray = StringUtilKt.base64Decode((String)object);
                    object = byArray;
                    if (byArray != null) break block6;
                }
                throw (Throwable)CodegenError.INSTANCE.iconsError("Could not decode base64 from: " + pngDataUri);
            }
            Object pngData = object;
            String dir = this.resDir + '/' + DrawableHelper.INSTANCE.drawableFolderForDensity(version.density());
            if (!FileSystem_UtilKt.VislyFS().exists(dir)) {
                FileSystem_UtilKt.VislyFS().mkdirs(dir);
            }
            String path = dir + '/' + name + ".png";
            this.createFile((byte[])pngData, path);
        }
    }

    private final void createFile(byte[] data, String path) {
        FileSystem_UtilKt.VislyFS().writeBytes(data, path);
    }

    public ImagesGenerator(@NotNull String resDir) {
        Intrinsics.checkParameterIsNotNull((Object)resDir, (String)"resDir");
        this.resDir = resDir;
    }
}

