/*
 * Decompiled with CFR 0.152.
 */
package app.visly;

import app.visly.Config;
import app.visly.Logger;
import app.visly.Visly;
import app.visly.VislyConfiguration;
import app.visly.VislyLog;
import app.visly.codegen.AssetGenerator;
import app.visly.codegen.AssetsGenerator;
import app.visly.codegen.color.ColorsGenerator;
import app.visly.codegen.image.ImagesGenerator;
import app.visly.codegen.string.StringsGenerator;
import app.visly.codegen.textstyle.TextStylesGenerator;
import app.visly.codegen.util.URLFileDownloader;
import app.visly.io.AssetsQuery;
import app.visly.io.Client;
import app.visly.project.ProjectInstaller;
import app.visly.version.LastCheck;
import app.visly.version.VersionChecker;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/visly/VislyImpl;", "Lapp/visly/Visly;", "config", "Lapp/visly/VislyConfiguration;", "assetsGenerator", "Lapp/visly/codegen/AssetsGenerator;", "projectInstaller", "Lapp/visly/project/ProjectInstaller;", "client", "Lapp/visly/io/Client;", "versionChecker", "Lapp/visly/version/VersionChecker;", "logger", "Lapp/visly/Logger;", "(Lapp/visly/VislyConfiguration;Lapp/visly/codegen/AssetsGenerator;Lapp/visly/project/ProjectInstaller;Lapp/visly/io/Client;Lapp/visly/version/VersionChecker;Lapp/visly/Logger;)V", "getConfig", "()Lapp/visly/VislyConfiguration;", "checkNewVersion", "", "install", "apiKey", "", "version", "serverUrl", "shouldCheckNewVersion", "", "visly-gradle-plugin"})
public class VislyImpl
implements Visly {
    @NotNull
    private final VislyConfiguration config;
    private final AssetsGenerator assetsGenerator;
    private final ProjectInstaller projectInstaller;
    private final Client client;
    private final VersionChecker versionChecker;

    @Override
    public void install(@NotNull String apiKey, @NotNull String version, @NotNull String serverUrl) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)serverUrl, (String)"serverUrl");
        VislyLog.INSTANCE.track("Install started");
        VislyLog.INSTANCE.d("Api-key: '" + apiKey + '\'');
        VislyLog.INSTANCE.d("Release: '" + version + '\'');
        VislyLog.INSTANCE.d("Server url: '" + serverUrl + '\'');
        VislyLog.INSTANCE.lc("Syncing project...");
        VislyLog.INSTANCE.lc("Fetching release version: '" + version + '\'');
        AssetsQuery.ReleaseInfo releaseInfo = this.client.fetchAssets(apiKey, version, serverUrl).team().releaseInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)releaseInfo, (String)"client.fetchAssets(apiKe\u2026Url).team().releaseInfo()");
        AssetsQuery.ReleaseInfo release = releaseInfo;
        VislyLog.INSTANCE.lc("Generating assets...");
        this.assetsGenerator.process(release);
        VislyLog.INSTANCE.lc("Installing project...");
        this.projectInstaller.install();
        VislyLog.INSTANCE.lc("Successfully installed!");
        VislyLog.INSTANCE.lc("Visly resources stored in: " + this.config.getOutputDir());
        VislyLog.INSTANCE.track("Install successful");
    }

    @Override
    public boolean shouldCheckNewVersion() {
        return this.versionChecker.shouldCheckNewVersion();
    }

    @Override
    public void checkNewVersion() {
        VislyLog.INSTANCE.lc("Current plugin version: " + Config.INSTANCE.getVERSION());
        VislyLog.INSTANCE.lc("Checking for newer version...");
        String string = this.versionChecker.checkNewVersion();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String newVersion = string2;
            boolean bl3 = false;
            VislyLog.INSTANCE.lc("**********************************************");
            VislyLog.INSTANCE.lc("A newer plugin version is available! -> " + newVersion);
            VislyLog.INSTANCE.lc("**********************************************");
        } else {
            VislyLog.INSTANCE.lc("Plugin is up-to-date.");
        }
    }

    @NotNull
    public final VislyConfiguration getConfig() {
        return this.config;
    }

    public VislyImpl(@NotNull VislyConfiguration config, @NotNull AssetsGenerator assetsGenerator, @NotNull ProjectInstaller projectInstaller, @NotNull Client client, @NotNull VersionChecker versionChecker, @Nullable Logger logger) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Intrinsics.checkParameterIsNotNull((Object)assetsGenerator, (String)"assetsGenerator");
            Intrinsics.checkParameterIsNotNull((Object)projectInstaller, (String)"projectInstaller");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)versionChecker, (String)"versionChecker");
            this.config = config;
            this.assetsGenerator = assetsGenerator;
            this.projectInstaller = projectInstaller;
            this.client = client;
            this.versionChecker = versionChecker;
            Logger logger2 = logger;
            if (logger2 == null) break block0;
            Logger logger3 = logger2;
            boolean bl = false;
            boolean bl2 = false;
            Logger it = logger3;
            boolean bl3 = false;
            VislyLog.INSTANCE.set(it);
        }
    }

    public /* synthetic */ VislyImpl(VislyConfiguration vislyConfiguration, AssetsGenerator assetsGenerator, ProjectInstaller projectInstaller, Client client, VersionChecker versionChecker, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            assetsGenerator = new AssetsGenerator(vislyConfiguration.getProjectDir(), CollectionsKt.listOf((Object[])new AssetGenerator[]{new ColorsGenerator(vislyConfiguration.getProjectResDir()), new ImagesGenerator(vislyConfiguration.getProjectResDir()), new StringsGenerator(vislyConfiguration.getProjectResDir()), new TextStylesGenerator(vislyConfiguration.getProjectResDir(), new URLFileDownloader())}));
        }
        if ((n & 4) != 0) {
            projectInstaller = new ProjectInstaller(vislyConfiguration.getProjectResDir(), vislyConfiguration.getOutputDir(), vislyConfiguration.getOutputResDir());
        }
        if ((n & 8) != 0) {
            client = new Client();
        }
        if ((n & 0x10) != 0) {
            LastCheck lastCheck = null;
            long l = vislyConfiguration.getVersionCheckIntervalInMillis();
            String string = Config.INSTANCE.getVERSION();
            String string2 = vislyConfiguration.getVersionLastCheckFile();
            versionChecker = new VersionChecker(client, string, l, string2, lastCheck, 16, null);
        }
        if ((n & 0x20) != 0) {
            logger = null;
        }
        this(vislyConfiguration, assetsGenerator, projectInstaller, client, versionChecker, logger);
    }
}

