/*
 * Decompiled with CFR 0.152.
 */
package app.visly.filesystem;

import app.visly.filesystem.DefaultFileOperations;
import app.visly.filesystem.FileOperations;
import app.visly.filesystem.FilePath;
import app.visly.filesystem.FileSystemConfiguration;
import app.visly.filesystem.FileSystemError;
import app.visly.filesystem.FileSystemKt;
import app.visly.filesystem.SystemUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0006J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J \u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lapp/visly/filesystem/FileSystem;", "Lapp/visly/filesystem/FileOperations;", "configuration", "Lapp/visly/filesystem/FileSystemConfiguration;", "paths", "", "Lapp/visly/filesystem/FilePath;", "", "operations", "(Lapp/visly/filesystem/FileSystemConfiguration;Ljava/util/Map;Lapp/visly/filesystem/FileOperations;)V", "assertInSystem", "", "path", "copy", "", "fromPath", "toPath", "delete", "deleteRecursively", "exists", "isInSystem", "mkdir", "mkdirs", "key", "readText", "charset", "Ljava/nio/charset/Charset;", "toString", "writeBytes", "bytes", "", "writeText", "text", "Companion", "visly-gradle-plugin"})
public final class FileSystem
implements FileOperations {
    private final Map<FilePath, String> paths;
    private final FileOperations operations;
    @NotNull
    public static FileSystem instance;
    public static final Companion Companion;

    @NotNull
    public final String path(@NotNull FilePath key) {
        String string;
        block3: {
            boolean bl;
            String string2;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)((Object)key), (String)"key");
                string = this.paths.get((Object)key);
                if (string == null) break block2;
                string2 = string;
                bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = it;
                if (string != null) break block3;
            }
            string2 = "Path with key: " + (Object)((Object)key) + " should be in file system";
            bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    public final boolean isInSystem(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String normalizedPath = FilesKt.normalize((File)new File(path)).getAbsolutePath();
        Iterable $this$forEach$iv = this.paths.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)normalizedPath, (Object)it)) {
                return true;
            }
            String string = normalizedPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"normalizedPath");
            if (!StringsKt.startsWith$default((String)string, (String)(it + '/'), (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    public final void assertInSystem(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!this.isInSystem(path)) {
            throw (Throwable)new FileSystemError("Path " + path + " is not in visly file system");
        }
    }

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assertInSystem(path);
        return this.operations.delete(path);
    }

    @Override
    public boolean deleteRecursively(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assertInSystem(path);
        return this.operations.deleteRecursively(path);
    }

    @Override
    public boolean mkdir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assertInSystem(path);
        return this.operations.mkdir(path);
    }

    @Override
    public boolean mkdirs(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assertInSystem(path);
        return this.operations.mkdirs(path);
    }

    @Override
    public boolean exists(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assertInSystem(path);
        return this.operations.exists(path);
    }

    @Override
    @NotNull
    public String readText(@NotNull String path, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.assertInSystem(path);
        return this.operations.readText(path, charset);
    }

    @Override
    public void writeText(@NotNull String text, @NotNull String path, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.assertInSystem(path);
        this.operations.writeText(text, path, charset);
    }

    @Override
    public void writeBytes(@NotNull byte[] bytes, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assertInSystem(path);
        this.operations.writeBytes(bytes, path);
    }

    @Override
    public boolean copy(@NotNull String fromPath, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        this.assertInSystem(toPath);
        return this.operations.copy(fromPath, toPath);
    }

    @NotNull
    public String toString() {
        return "\n        FileSystem:\n        outputDir: " + this.path(FilePath.OUTPUT_DIR) + "\n        projectDir: " + this.path(FilePath.PROJECT_DIR) + "\n        homeDir: " + this.path(FilePath.HOME_DIR) + "\n        ";
    }

    public FileSystem(@NotNull FileSystemConfiguration configuration, @NotNull Map<FilePath, String> paths, @NotNull FileOperations operations) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        Intrinsics.checkParameterIsNotNull((Object)operations, (String)"operations");
        this.paths = paths;
        this.operations = operations;
        FileSystemKt.access$assertValidFileSystem(this);
    }

    public /* synthetic */ FileSystem(FileSystemConfiguration fileSystemConfiguration, Map map, FileOperations fileOperations, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)FilePath.HOME_DIR), (Object)fileSystemConfiguration.getHomeDir()), TuplesKt.to((Object)((Object)FilePath.PROJECT_DIR), (Object)fileSystemConfiguration.getProjectDir()), TuplesKt.to((Object)((Object)FilePath.OUTPUT_DIR), (Object)fileSystemConfiguration.getOutputDir())});
        }
        if ((n & 4) != 0) {
            fileOperations = new DefaultFileOperations();
        }
        this(fileSystemConfiguration, map, fileOperations);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lapp/visly/filesystem/FileSystem$Companion;", "", "()V", "instance", "Lapp/visly/filesystem/FileSystem;", "getInstance", "()Lapp/visly/filesystem/FileSystem;", "setInstance", "(Lapp/visly/filesystem/FileSystem;)V", "setup", "", "projectDir", "", "visly-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final FileSystem getInstance() {
            FileSystem fileSystem = instance;
            if (fileSystem == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            }
            return fileSystem;
        }

        public final void setInstance(@NotNull FileSystem fileSystem) {
            Intrinsics.checkParameterIsNotNull((Object)fileSystem, (String)"<set-?>");
            instance = fileSystem;
        }

        public final void setup(@NotNull String projectDir) {
            Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
            this.setInstance(new FileSystem(new FileSystemConfiguration(SystemUtil.INSTANCE.userHomeDir() + "/.visly", FileSystemKt.access$projectRootDir(), projectDir + "/src/visly/gen"), null, null, 6, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

