/*
 * Decompiled with CFR 0.152.
 */
package app.visly.codegen.image;

import app.visly.CodegenError;
import app.visly.VislyLog;
import app.visly.codegen.AssetGenerator;
import app.visly.codegen.image.MediaType;
import app.visly.codegen.image.SVGParser;
import app.visly.codegen.util.StringUtilKt;
import app.visly.filesystem.FileSystem_UtilKt;
import app.visly.io.AssetsQuery;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0014\u0010\n\u001a\u00020\u00062\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/visly/codegen/image/ImagesGenerator;", "Lapp/visly/codegen/AssetGenerator;", "resDir", "", "(Ljava/lang/String;)V", "createFile", "", "data", "", "name", "generateAssets", "release", "Lapp/visly/io/AssetsQuery$ReleaseInfo;", "Lapp/visly/codegen/Release;", "generateImage", "icon", "Lapp/visly/io/AssetsQuery$Icon;", "generateSVG", "svg", "visly-gradle-plugin"})
public final class ImagesGenerator
implements AssetGenerator {
    private final String resDir;

    @Override
    public void generateAssets(@NotNull AssetsQuery.ReleaseInfo release) {
        Intrinsics.checkParameterIsNotNull((Object)release, (String)"release");
        FileSystem_UtilKt.VislyFS().mkdirs(this.resDir + "/drawable");
        List<AssetsQuery.Icon> list = release.icons();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"release.icons()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssetsQuery.Icon it = (AssetsQuery.Icon)element$iv;
            boolean bl = false;
            AssetsQuery.Icon icon = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"it");
            this.generateImage(icon);
        }
    }

    private final void generateImage(AssetsQuery.Icon icon) {
        String string = icon.base64();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"icon.base64()");
        String image = string;
        String string2 = StringUtilKt.dataUrlMediaType(image);
        if (string2 == null) {
            throw (Throwable)CodegenError.INSTANCE.iconsError("Could not get mime type from: " + image);
        }
        String mediaType = string2;
        String string3 = StringUtilKt.dataUrlBase64(image);
        if (string3 == null) {
            throw (Throwable)CodegenError.INSTANCE.iconsError("Could not get data segment type: " + image);
        }
        String dataBase64 = string3;
        String string4 = StringUtilKt.base64Decode(dataBase64);
        if (string4 == null) {
            throw (Throwable)CodegenError.INSTANCE.iconsError("Could not decode base64 from: " + image);
        }
        String data = string4;
        String string5 = mediaType;
        if (!Intrinsics.areEqual((Object)string5, (Object)MediaType.IMG_SVG_XML.getType())) {
            throw (Throwable)CodegenError.INSTANCE.iconsError("Image " + icon + ".name() uses unsupported media type: " + mediaType + ". Perhaps upgrade Visly plugin?");
        }
        StringBuilder stringBuilder = new StringBuilder().append("visly_");
        String string6 = icon.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"icon.name()");
        String name = stringBuilder.append(StringUtilKt.toValidResourceName(string6)).toString();
        this.generateSVG(data, name);
        VislyLog.INSTANCE.d("Generated icon: " + name);
    }

    private final void generateSVG(String svg, String name) {
        String data;
        String string = data = new SVGParser().parse(svg, name);
        Charset charset = Charsets.UTF_8;
        ImagesGenerator imagesGenerator = this;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        imagesGenerator.createFile(byArray2, name);
    }

    private final void createFile(byte[] data, String name) {
        FileSystem_UtilKt.VislyFS().writeBytes(data, this.resDir + "/drawable/" + name + ".xml");
    }

    public ImagesGenerator(@NotNull String resDir) {
        Intrinsics.checkParameterIsNotNull((Object)resDir, (String)"resDir");
        this.resDir = resDir;
    }
}

