/*
 * Decompiled with CFR 0.152.
 */
package app.visly.codegen.color;

import app.visly.VislyLog;
import app.visly.codegen.AssetGenerator;
import app.visly.codegen.color.ColorParser;
import app.visly.codegen.util.StringUtilKt;
import app.visly.filesystem.FileSystem_UtilKt;
import app.visly.io.AssetsQuery;
import com.commit451.resourcespoet.ResourcesPoet;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/visly/codegen/color/ColorsGenerator;", "Lapp/visly/codegen/AssetGenerator;", "resDir", "", "(Ljava/lang/String;)V", "generateAssets", "", "release", "Lapp/visly/io/AssetsQuery$ReleaseInfo;", "Lapp/visly/codegen/Release;", "generateCode", "", "visly-gradle-plugin"})
public final class ColorsGenerator
implements AssetGenerator {
    private final String resDir;

    @Override
    public void generateAssets(@NotNull AssetsQuery.ReleaseInfo release) {
        Intrinsics.checkParameterIsNotNull((Object)release, (String)"release");
        FileSystem_UtilKt.VislyFS().mkdirs(this.resDir + "/values");
        FileSystem_UtilKt.VislyFS().writeBytes(this.generateCode(release), this.resDir + "/values/colors.xml");
    }

    private final byte[] generateCode(AssetsQuery.ReleaseInfo release) {
        ResourcesPoet resPoet = ResourcesPoet.Companion.create(true);
        List<AssetsQuery.Color> list = release.colors();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"release.colors()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssetsQuery.Color it = (AssetsQuery.Color)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("visly_");
            String string = it.name();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
            String name = stringBuilder.append(StringUtilKt.toValidResourceName(string)).toString();
            AssetsQuery.Color color = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"it");
            resPoet.addColor(name, ColorParser.INSTANCE.parse(color));
            VislyLog.INSTANCE.d("Generated color: " + name);
        }
        String string = resPoet.build();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public ColorsGenerator(@NotNull String resDir) {
        Intrinsics.checkParameterIsNotNull((Object)resDir, (String)"resDir");
        this.resDir = resDir;
    }
}

