package app.visly.gradle

import app.visly.Visly
import org.gradle.api.DefaultTask
import org.gradle.api.GradleException
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction

open class InstallTask : DefaultTask() {

    var visly: Visly? = null

    private val conf: VislyPluginExtension = project.extensions.findByName("visly") as VislyPluginExtension

    @Input
    fun version(): String {
        return conf.version?.let { it } ?: "latest"
    }

    @Input
    fun apiKey(): String {
        return System.getenv("VISLY_API_KEY")?.let { it }
            ?: conf.apiKey?.let { it }
            ?: throw GradleException("Visly api key not provided.")
    }

    @TaskAction
    fun install() {
        val visly = this.visly?.let { it } ?: throw GradleException("Visly was not provided.")
        visly.install(apiKey(), version())
    }
}