package app.visly.gradle

import app.visly.ProjectSetup
import app.visly.Visly
import app.visly.VislyLog
import org.gradle.api.DefaultTask
import org.gradle.api.GradleException
import org.gradle.api.tasks.TaskAction

open class CopyResourcesTask : DefaultTask() {

    var visly: Visly? = null

    var target: ProjectSetup? = null

    @TaskAction
    fun copyResources() {

        VislyLog.lc("Copying assets...")
        val visly = this.visly?.let { it } ?: throw GradleException("Visly was not provided.")
        val target = target?.let { it } ?: throw GradleException("Visly was not configured")

        project.delete {
            it.delete(target.rootDir)
        }

        project.copy {
            it.from(visly.config.project.rootDir)
            it.into(target.rootDir)
        }
    }
}