package app.visly.codegen.util

import okhttp3.OkHttpClient
import okhttp3.Request

interface FileDownloader {
    fun download(url: String): ByteArray
}

class URLFileDownloader : FileDownloader {
    override fun download(url: String): ByteArray {
        val client = OkHttpClient()

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).execute().use { response ->
            if (!response.isSuccessful) throw VislyException("Unexpected code $response")
            val body = response.body() ?: throw VislyException("Unexpected null body")
            return body.bytes()
        }
    }
}

class MockFileDownloader(private val response: ByteArray) : FileDownloader {
    override fun download(url: String): ByteArray {
        return this.response
    }
}