package app.visly.codegen.image

import app.visly.VislyLog
import com.android.ide.common.vectordrawable.Svg2Vector
import java.io.ByteArrayOutputStream

class SVGParser {

    fun parse(svg: String, name: String = "temp"): String {
        val file = java.io.File.createTempFile(name, ".svg")
        file.writeBytes(svg.toByteArray())
        val stream = ByteArrayOutputStream()
        val result = Svg2Vector.parseSvgToXml(file, stream)
        if (result.isNullOrEmpty().not()) {
            VislyLog.w("Svg uses unsupported features. Result might be inconsistent for svg named '$name'.\n$result")
        }
        return String(stream.toByteArray())
    }
}