/*
 * Decompiled with CFR 0.152.
 */
package app.visly;

import app.visly.Configuration;
import app.visly.Logger;
import app.visly.VislyLog;
import app.visly.codegen.AssetGenerator;
import app.visly.codegen.AssetsGenerator;
import app.visly.codegen.color.ColorsGenerator;
import app.visly.codegen.image.ImagesGenerator;
import app.visly.codegen.string.StringsGenerator;
import app.visly.codegen.textstyle.TextStylesGenerator;
import app.visly.codegen.util.URLFileDownloader;
import app.visly.io.AssetsQuery;
import app.visly.io.Client;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lapp/visly/Visly;", "", "config", "Lapp/visly/Configuration;", "assetsGenerator", "Lapp/visly/codegen/AssetsGenerator;", "client", "Lapp/visly/io/Client;", "logger", "Lapp/visly/Logger;", "(Lapp/visly/Configuration;Lapp/visly/codegen/AssetsGenerator;Lapp/visly/io/Client;Lapp/visly/Logger;)V", "getConfig", "()Lapp/visly/Configuration;", "install", "", "apiKey", "", "version", "write", "fileName", "text", "visly-gradle-plugin"})
public final class Visly {
    @NotNull
    private final Configuration config;
    private final AssetsGenerator assetsGenerator;
    private final Client client;

    public final void install(@NotNull String apiKey, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        VislyLog.INSTANCE.d("Api-key: '" + apiKey + '\'');
        VislyLog.INSTANCE.d("Release: '" + version + '\'');
        VislyLog.INSTANCE.lc("Syncing project...");
        VislyLog.INSTANCE.lc("Fetching release version: '" + version + '\'');
        AssetsQuery.ReleaseInfo releaseInfo = this.client.fetchAssets(apiKey, version).team().releaseInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)releaseInfo, (String)"client.fetchAssets(apiKe\u2026ion).team().releaseInfo()");
        AssetsQuery.ReleaseInfo release = releaseInfo;
        VislyLog.INSTANCE.lc("Generating assets...");
        this.assetsGenerator.process(release);
        this.write(this.config.getProject().getRootDir() + "/visly.version", version);
    }

    private final void write(String fileName, String text) {
        File file = new File(fileName);
        file.createNewFile();
        FilesKt.writeText$default((File)file, (String)text, null, (int)2, null);
    }

    @NotNull
    public final Configuration getConfig() {
        return this.config;
    }

    public Visly(@NotNull Configuration config, @NotNull AssetsGenerator assetsGenerator, @NotNull Client client, @Nullable Logger logger) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Intrinsics.checkParameterIsNotNull((Object)assetsGenerator, (String)"assetsGenerator");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            this.config = config;
            this.assetsGenerator = assetsGenerator;
            this.client = client;
            Logger logger2 = logger;
            if (logger2 == null) break block0;
            Logger logger3 = logger2;
            boolean bl = false;
            boolean bl2 = false;
            Logger it = logger3;
            boolean bl3 = false;
            VislyLog.INSTANCE.set(it);
        }
    }

    public /* synthetic */ Visly(Configuration configuration, AssetsGenerator assetsGenerator, Client client, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            assetsGenerator = new AssetsGenerator(configuration.getProject(), CollectionsKt.listOf((Object[])new AssetGenerator[]{new ColorsGenerator(configuration.getProject().getResDir()), new ImagesGenerator(configuration.getProject().getResDir()), new StringsGenerator(configuration.getProject().getResDir()), new TextStylesGenerator(configuration.getProject().getResDir(), new URLFileDownloader())}));
        }
        if ((n & 4) != 0) {
            client = new Client();
        }
        if ((n & 8) != 0) {
            logger = null;
        }
        this(configuration, assetsGenerator, client, logger);
    }
}

