package app.visly.gradle

import app.visly.Configuration
import app.visly.ProjectSetup
import app.visly.Visly
import com.android.build.gradle.AppExtension
import com.android.build.gradle.AppPlugin
import org.gradle.api.Plugin
import org.gradle.api.Project

class VislyPlugin : Plugin<Project> {

    override fun apply(project: Project) {

        project.extensions.create("visly", VislyPluginExtension::class.java)

        project.plugins.all {
            when (it) {
                is AppPlugin -> {
                    project.extensions.findByType(AppExtension::class.java)?.run {
                        registerTask(project = project, appExtension = this)
                    }
                }
            }
        }
    }

    private fun registerTask(project: Project, appExtension: AppExtension) {

        val visly = Visly(
            config = Configuration(
                project = ProjectSetup("${project.projectDir}/.visly/build")
            ),
            logger = GradleLogger(project.logger)
        )

        // Install
        val installTask = project.tasks.create("installVisly", InstallTask::class.java)
        installTask.visly = visly

        // Copy
        val copyTarget = ProjectSetup("${project.projectDir}/build/generated/visly")
        val copyTask = project.tasks.create("copyVislyResources", CopyResourcesTask::class.java)
        copyTask.visly = visly
        copyTask.target = copyTarget

        installTask.finalizedBy("copyVislyResources")

        appExtension.applicationVariants.all {
            it.registerGeneratedResFolders(project.files(copyTarget.resDir).builtBy(copyTask))
        }
    }
}