package app.visly.codegen.util

import com.google.common.base.CaseFormat
import java.util.*
import java.util.regex.Pattern

const val dataUriBase64Regex = "data:([a-zA-Z]*/[a-zA-Z+]*);(base64),([^\"]*)"

fun String.dataUrlMediaType(): String? {
    val pattern = Pattern.compile(dataUriBase64Regex)
    val matcher = pattern.matcher(this)
    if (matcher.matches()) return matcher.toMatchResult().group(1)
    return null
}

fun String.dataUrlBase64(): String? {
    val pattern = Pattern.compile(dataUriBase64Regex)
    val matcher = pattern.matcher(this)
    if (matcher.matches()) {
        return matcher.toMatchResult().group(3)
    }
    return null
}

fun String.base64Decode(): String? {
    try {
        return String(Base64.getMimeDecoder().decode(this))
    } catch (e: Exception) { /* Not base 64 */ }
    return null
}

// TODO remove when supported
const val invalidResourceChars = "[^0-9a-z_]+"

fun String.toValidResourceName(): String {
    return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this)
            .replace(" ", "_")
            .replace(invalidResourceChars, "")
}