package app.visly.codegen

import app.visly.ProjectSetup
import app.visly.codegen.util.VislyException
import app.visly.io.AssetsQuery
import java.io.File

typealias Release = AssetsQuery.ReleaseInfo
typealias Data = AssetsQuery.Data
typealias Team = AssetsQuery.Team

class AssetsGenerator(
    private val project: ProjectSetup,
    private val generators: List<AssetGenerator>
) {

    fun process(release: Release) {
        // Clean root
        val out = File(project.rootDir)
        if (out.exists()) {
            if (!out.deleteRecursively()) {
                throw VislyException("Failed to clean project root.")
            }
        }
        out.mkdirs()

        generators.forEach { it.generateAssets(release) }
    }

    private fun write(filePath: String, content: String) {
        val file = File(filePath)
        file.createNewFile()
        file.writeText(content)
    }
}