package app.visly

import app.visly.codegen.AssetsGenerator
import app.visly.codegen.color.ColorsGenerator
import app.visly.codegen.image.ImagesGenerator
import app.visly.codegen.string.StringsGenerator
import app.visly.codegen.textstyle.TextStylesGenerator
import app.visly.codegen.util.URLFileDownloader
import app.visly.io.Client
import java.io.File

class Visly(
    val config: Configuration,
    private val assetsGenerator: AssetsGenerator = AssetsGenerator(
        config.project,
        listOf(
            ColorsGenerator(config.project.resDir),
            ImagesGenerator(config.project.resDir),
            StringsGenerator(config.project.resDir),
            TextStylesGenerator(config.project.resDir, URLFileDownloader())
        )
    ),
    private val client: Client = Client(),
    logger: Logger? = null
) {

    init { logger?.let { VislyLog.set(it) } }

    fun install(apiKey: String, version: String) {
        VislyLog.d("Api-key: '$apiKey'")
        VislyLog.d("Release: '$version'")
        VislyLog.lc("Syncing project...")

        VislyLog.lc("Fetching release version: '$version'")
        val release = client.fetchAssets(apiKey, version).team().releaseInfo()

        VislyLog.lc("Generating assets...")
        assetsGenerator.process(release)

        write("${config.project.rootDir}/visly.version", version)
    }

    private fun write(fileName: String, text: String) {
        val file = File(fileName)
        file.createNewFile()
        file.writeText(text)
    }
}