/*
 * Decompiled with CFR 0.152.
 */
package app.visly.io;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssetsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "7d0e6ba10ac11fd7134bdb3d5aed452b7dfe62623428c63d55777ae7745fdfb5";
    public static final String QUERY_DOCUMENT = "query Assets($apiToken: String!, $version: String!, $iconMimeType: String) {\n  team(apiToken: $apiToken) {\n    __typename\n    releaseInfo(version: $version) {\n      __typename\n      components {\n        __typename\n        title\n        vml\n      }\n      colors {\n        __typename\n        name\n        red\n        green\n        blue\n        alpha\n      }\n      icons {\n        __typename\n        name\n        base64(mimeType: $iconMimeType)\n      }\n      appStrings {\n        __typename\n        name\n        value\n      }\n    }\n  }\n}";
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "Assets";
        }
    };
    private final Variables variables;

    public AssetsQuery(@NotNull String apiToken, @NotNull String version, @NotNull Input<String> iconMimeType) {
        Utils.checkNotNull((Object)apiToken, (Object)"apiToken == null");
        Utils.checkNotNull((Object)version, (Object)"version == null");
        Utils.checkNotNull(iconMimeType, (Object)"iconMimeType == null");
        this.variables = new Variables(apiToken, version, iconMimeType);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    public static class AppString {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"value", (String)"value", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        @NotNull
        final String value;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AppString(@NotNull String __typename, @NotNull String name, @NotNull String value) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.value = (String)Utils.checkNotNull((Object)value, (Object)"value == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public String value() {
            return this.value;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeString($responseFields[2], value);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AppString{__typename=" + this.__typename + ", name=" + this.name + ", value=" + this.value + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AppString) {
                AppString that = (AppString)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.value.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AppString> {
            public AppString map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                String value = reader.readString($responseFields[2]);
                return new AppString(__typename, name, value);
            }
        }
    }

    public static class Icon {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"base64", (String)"base64", (Map)new UnmodifiableMapBuilder(1).put((Object)"mimeType", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"iconMimeType").build()).build(), (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        @NotNull
        final String base64;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Icon(@NotNull String __typename, @NotNull String name, @NotNull String base64) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.base64 = (String)Utils.checkNotNull((Object)base64, (Object)"base64 == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public String base64() {
            return this.base64;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeString($responseFields[2], base64);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Icon{__typename=" + this.__typename + ", name=" + this.name + ", base64=" + this.base64 + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Icon) {
                Icon that = (Icon)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.base64.equals(that.base64);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.base64.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Icon> {
            public Icon map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                String base64 = reader.readString($responseFields[2]);
                return new Icon(__typename, name, base64);
            }
        }
    }

    public static class Color {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"red", (String)"red", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"green", (String)"green", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"blue", (String)"blue", null, (boolean)false, Collections.emptyList()), ResponseField.forDouble((String)"alpha", (String)"alpha", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        final int red;
        final int green;
        final int blue;
        final double alpha;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Color(@NotNull String __typename, @NotNull String name, int red, int green, int blue, double alpha) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        public int red() {
            return this.red;
        }

        public int green() {
            return this.green;
        }

        public int blue() {
            return this.blue;
        }

        public double alpha() {
            return this.alpha;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeInt($responseFields[2], Integer.valueOf(red));
                    writer.writeInt($responseFields[3], Integer.valueOf(green));
                    writer.writeInt($responseFields[4], Integer.valueOf(blue));
                    writer.writeDouble($responseFields[5], Double.valueOf(alpha));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Color{__typename=" + this.__typename + ", name=" + this.name + ", red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Color) {
                Color that = (Color)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.red == that.red && this.green == that.green && this.blue == that.blue && Double.doubleToLongBits(this.alpha) == Double.doubleToLongBits(that.alpha);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                h ^= this.red;
                h *= 1000003;
                h ^= this.green;
                h *= 1000003;
                h ^= this.blue;
                h *= 1000003;
                this.$hashCode = h ^= Double.valueOf(this.alpha).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Color> {
            public Color map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                int red = reader.readInt($responseFields[2]);
                int green = reader.readInt($responseFields[3]);
                int blue = reader.readInt($responseFields[4]);
                double alpha = reader.readDouble($responseFields[5]);
                return new Color(__typename, name, red, green, blue, alpha);
            }
        }
    }

    public static class Component {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"vml", (String)"vml", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String title;
        @NotNull
        final String vml;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Component(@NotNull String __typename, @NotNull String title, @NotNull String vml) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.title = (String)Utils.checkNotNull((Object)title, (Object)"title == null");
            this.vml = (String)Utils.checkNotNull((Object)vml, (Object)"vml == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @NotNull
        public String vml() {
            return this.vml;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], title);
                    writer.writeString($responseFields[2], vml);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Component{__typename=" + this.__typename + ", title=" + this.title + ", vml=" + this.vml + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Component) {
                Component that = (Component)o;
                return this.__typename.equals(that.__typename) && this.title.equals(that.title) && this.vml.equals(that.vml);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.title.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.vml.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Component> {
            public Component map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String title = reader.readString($responseFields[1]);
                String vml = reader.readString($responseFields[2]);
                return new Component(__typename, title, vml);
            }
        }
    }

    public static class ReleaseInfo {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"components", (String)"components", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"colors", (String)"colors", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"icons", (String)"icons", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"appStrings", (String)"appStrings", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Component> components;
        @NotNull
        final List<Color> colors;
        @NotNull
        final List<Icon> icons;
        @NotNull
        final List<AppString> appStrings;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public ReleaseInfo(@NotNull String __typename, @NotNull List<Component> components, @NotNull List<Color> colors, @NotNull List<Icon> icons, @NotNull List<AppString> appStrings) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.components = (List)Utils.checkNotNull(components, (Object)"components == null");
            this.colors = (List)Utils.checkNotNull(colors, (Object)"colors == null");
            this.icons = (List)Utils.checkNotNull(icons, (Object)"icons == null");
            this.appStrings = (List)Utils.checkNotNull(appStrings, (Object)"appStrings == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Component> components() {
            return this.components;
        }

        @NotNull
        public List<Color> colors() {
            return this.colors;
        }

        @NotNull
        public List<Icon> icons() {
            return this.icons;
        }

        @NotNull
        public List<AppString> appStrings() {
            return this.appStrings;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], components, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Component)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[2], colors, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Color)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[3], icons, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Icon)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[4], appStrings, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((AppString)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "ReleaseInfo{__typename=" + this.__typename + ", components=" + this.components + ", colors=" + this.colors + ", icons=" + this.icons + ", appStrings=" + this.appStrings + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ReleaseInfo) {
                ReleaseInfo that = (ReleaseInfo)o;
                return this.__typename.equals(that.__typename) && this.components.equals(that.components) && this.colors.equals(that.colors) && this.icons.equals(that.icons) && this.appStrings.equals(that.appStrings);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.components.hashCode();
                h *= 1000003;
                h ^= this.colors.hashCode();
                h *= 1000003;
                h ^= this.icons.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.appStrings.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<ReleaseInfo> {
            final Component.Mapper componentFieldMapper = new Component.Mapper();
            final Color.Mapper colorFieldMapper = new Color.Mapper();
            final Icon.Mapper iconFieldMapper = new Icon.Mapper();
            final AppString.Mapper appStringFieldMapper = new AppString.Mapper();

            public ReleaseInfo map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List components = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Component>(){

                    public Component read(ResponseReader.ListItemReader listItemReader) {
                        return (Component)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Component>(){

                            public Component read(ResponseReader reader) {
                                return componentFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List colors = reader.readList($responseFields[2], (ResponseReader.ListReader)new ResponseReader.ListReader<Color>(){

                    public Color read(ResponseReader.ListItemReader listItemReader) {
                        return (Color)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Color>(){

                            public Color read(ResponseReader reader) {
                                return colorFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List icons = reader.readList($responseFields[3], (ResponseReader.ListReader)new ResponseReader.ListReader<Icon>(){

                    public Icon read(ResponseReader.ListItemReader listItemReader) {
                        return (Icon)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Icon>(){

                            public Icon read(ResponseReader reader) {
                                return iconFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List appStrings = reader.readList($responseFields[4], (ResponseReader.ListReader)new ResponseReader.ListReader<AppString>(){

                    public AppString read(ResponseReader.ListItemReader listItemReader) {
                        return (AppString)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AppString>(){

                            public AppString read(ResponseReader reader) {
                                return appStringFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new ReleaseInfo(__typename, components, colors, icons, appStrings);
            }
        }
    }

    public static class Team {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"releaseInfo", (String)"releaseInfo", (Map)new UnmodifiableMapBuilder(1).put((Object)"version", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"version").build()).build(), (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final ReleaseInfo releaseInfo;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Team(@NotNull String __typename, @NotNull ReleaseInfo releaseInfo) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.releaseInfo = (ReleaseInfo)Utils.checkNotNull((Object)releaseInfo, (Object)"releaseInfo == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public ReleaseInfo releaseInfo() {
            return this.releaseInfo;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], releaseInfo.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Team{__typename=" + this.__typename + ", releaseInfo=" + this.releaseInfo + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Team) {
                Team that = (Team)o;
                return this.__typename.equals(that.__typename) && this.releaseInfo.equals(that.releaseInfo);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.releaseInfo.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Team> {
            final ReleaseInfo.Mapper releaseInfoFieldMapper = new ReleaseInfo.Mapper();

            public Team map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                ReleaseInfo releaseInfo = (ReleaseInfo)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<ReleaseInfo>(){

                    public ReleaseInfo read(ResponseReader reader) {
                        return releaseInfoFieldMapper.map(reader);
                    }
                });
                return new Team(__typename, releaseInfo);
            }
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"team", (String)"team", (Map)new UnmodifiableMapBuilder(1).put((Object)"apiToken", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"apiToken").build()).build(), (boolean)false, Collections.emptyList())};
        @NotNull
        final Team team;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@NotNull Team team) {
            this.team = (Team)Utils.checkNotNull((Object)team, (Object)"team == null");
        }

        @NotNull
        public Team team() {
            return this.team;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], team.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{team=" + this.team + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.team.equals(that.team);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.team.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Team.Mapper teamFieldMapper = new Team.Mapper();

            public Data map(ResponseReader reader) {
                Team team = (Team)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Team>(){

                    public Team read(ResponseReader reader) {
                        return teamFieldMapper.map(reader);
                    }
                });
                return new Data(team);
            }
        }
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String apiToken;
        @NotNull
        private final String version;
        private final Input<String> iconMimeType;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String apiToken, @NotNull String version, Input<String> iconMimeType) {
            this.apiToken = apiToken;
            this.version = version;
            this.iconMimeType = iconMimeType;
            this.valueMap.put("apiToken", apiToken);
            this.valueMap.put("version", version);
            if (iconMimeType.defined) {
                this.valueMap.put("iconMimeType", iconMimeType.value);
            }
        }

        @NotNull
        public String apiToken() {
            return this.apiToken;
        }

        @NotNull
        public String version() {
            return this.version;
        }

        public Input<String> iconMimeType() {
            return this.iconMimeType;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeString("apiToken", apiToken);
                    writer.writeString("version", version);
                    if (((Variables)this).iconMimeType.defined) {
                        writer.writeString("iconMimeType", (String)((Variables)this).iconMimeType.value);
                    }
                }
            };
        }
    }

    public static final class Builder {
        @NotNull
        private String apiToken;
        @NotNull
        private String version;
        private Input<String> iconMimeType = Input.absent();

        Builder() {
        }

        public Builder apiToken(@NotNull String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder version(@NotNull String version) {
            this.version = version;
            return this;
        }

        public Builder iconMimeType(@Nullable String iconMimeType) {
            this.iconMimeType = Input.fromNullable((Object)iconMimeType);
            return this;
        }

        public Builder iconMimeTypeInput(@NotNull Input<String> iconMimeType) {
            this.iconMimeType = (Input)Utils.checkNotNull(iconMimeType, (Object)"iconMimeType == null");
            return this;
        }

        public AssetsQuery build() {
            Utils.checkNotNull((Object)this.apiToken, (Object)"apiToken == null");
            Utils.checkNotNull((Object)this.version, (Object)"version == null");
            return new AssetsQuery(this.apiToken, this.version, this.iconMimeType);
        }
    }
}

