package app.visly.codegen.color

import app.visly.VislyLog
import app.visly.codegen.AssetGenerator
import app.visly.codegen.AssetUtil
import app.visly.codegen.Release
import app.visly.codegen.util.toValidResourceName
import com.commit451.resourcespoet.ResourcesPoet
import java.io.File

class ColorsGenerator(private val resDir: String) : AssetGenerator {

    override fun generateAssets(release: Release) {
        File("$resDir/values").mkdirs()
        val code = generateCode(release)
        val file = File("$resDir/values/colors.xml")
        file.createNewFile()
        file.writeBytes(code)
    }

    private fun generateCode(release: Release): ByteArray {
        val resPoet = ResourcesPoet.create(true)
        release.colors().forEach {
            val name = "${AssetUtil.resource_prefix}${it.name().toValidResourceName()}"
            resPoet.addColor(name, ColorParser.parse(it))
            VislyLog.d("Generated color: $name")
        }

        return resPoet.build().toByteArray(Charsets.UTF_8)
    }
}