package app.visly.shard

import android.content.Context
import android.content.ContextWrapper
import android.graphics.Typeface

internal interface ActionDelegate {
    fun on(action: String, value: JsonValue?)
}

class ShardContext(ctx: Context, public val fontCollection: MutableMap<String, Typeface> = mutableMapOf()) : ContextWrapper(ctx) {
    internal var actionDelegate: ActionDelegate? = null

    fun dispatch(action: String, value: JsonValue?) {
        this.actionDelegate?.on(action, value)
    }
}