package tookan.tookantrack.utils;

import android.content.Context;

import tookan.tookantrack.TookanLocationMode;
import tookan.tookantrack.metering.Keys;
import tookan.tookantrack.metering.utils.Prefs;

/**
 * Fetches data for which the App is dependent to communicate with Server
 *
 * @author Rishabh
 */
public class TrackingDependencies {

    /**
     * Method to save Access Token
     *
     * @param accessToken
     */
    public static void saveKey(Context context, String accessToken) {

        Prefs.with(context).save(Keys.Prefs.KEY, accessToken);
    }

    /**
     * Extracts access_token of user from shared preferences
     *
     * @param context
     * @return access_token if exists else
     */
    public static String getKey(Context context) {

        return Prefs.with(context).getString(Keys.Prefs.KEY, TookanLocationMode.EMPTY_STRING);
    }

    /**
     * Method to save Access Token
     *
     * @param accessToken
     */
    public static void saveUserId(Context context, String accessToken) {

        Prefs.with(context).save(Keys.Prefs.UNIQUE_USER_ID, accessToken);
    }

    /**
     * Extracts access_token of user from shared preferences
     *
     * @param context
     * @return access_token if exists else
     */
    public static String getUserId(Context context) {

        return Prefs.with(context).getString(Keys.Prefs.UNIQUE_USER_ID, TookanLocationMode.EMPTY_STRING);
    }

    /**
     * Method to save the Session ID
     *
     * @param context
     * @param sessionId
     */
    public static void saveSessionId(Context context, String sessionId) {

        Prefs.with(context).save(Keys.Prefs.SESSION_ID, sessionId);
    }

    /**
     * Method to save the Session ID
     *
     * @param context
     */
    public static String getSessionId(Context context) {

        return Prefs.with(context).getString(Keys.Prefs.SESSION_ID, null);
    }

}
