package tookan.tookantrack.retrofit2;


import android.content.Context;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Rest Client
 */
public class TrackingRestClient {


    public static Retrofit retrofit = null;
    static Integer BKS_KEYSTORE_RAW_FILE_ID = 0;
    // Integer BKS_KEYSTORE_RAW_FILE_ID = R.raw.keystorebks;
    static Integer SSL_KEY_PASSWORD_STRING_ID = 0;
    //Integer SSL_KEY_PASSWORD_STRING_ID = R.string.sslKeyPassword;

    /**
     * @return
     */
    public static TrackingApiInterface getApiInterface(Context context) {
        if (retrofit == null || !TrackingConfig.isRelease()) {

            try {
                retrofit = new Retrofit.Builder()
                        // .baseUrl("http://52.90.184.241:3000/")
                        .baseUrl("http://tracking.tookan.io:3008/")
                        //.baseUrl("https://api.github.com/")
                        .addConverterFactory(GsonConverterFactory.create())
                        .client(httpClient().build())
                        //.client(secureConnection().build())
                        .build();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retrofit.create(TrackingApiInterface.class);
    }


    /**
     * @return
     */
    public static Retrofit getRetrofitBuilder(Context context) {
        if (retrofit == null || !TrackingConfig.isRelease()) {
            retrofit = new Retrofit.Builder()
                    // .baseUrl("http://52.90.184.241:3000/")
                    .baseUrl(TrackingConfig.getServerUrl(context))
                    //.baseUrl("https://api.github.com/")
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(httpClient().build())
                    .build();
        }
        return retrofit;
    }

    /**
     * @return
     */
    private static OkHttpClient.Builder httpClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        // set your desired log level
        //logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();

        // add your other interceptors …
        // add logging as last interceptor
        httpClient.addInterceptor(logging);
        return httpClient;
    }


}
