package tookan.tookantrack.retrofit2;

import java.util.HashMap;

import okhttp3.RequestBody;

/**
 * Created by cl-macmini-33 on 27/09/16.
 */

public class TrackingRequestBodyParams {
    HashMap<String, RequestBody> map = new HashMap<>();

    private TrackingRequestBodyParams(Builder builder) {
        this.map = builder.map;

    }

    public HashMap<String, RequestBody> getMap() {
        return map;
    }


    public static class Builder {
        HashMap<String, RequestBody> map = new HashMap<>();

        public Builder() {
        }

        public Builder add(String key, Object value) {
            map.put(key, TrackingRetrofitUtils.getRequestBodyFromString(String.valueOf(value)));
            return this;
        }

        public TrackingRequestBodyParams build() {
            return new TrackingRequestBodyParams(this);
        }
    }
}


