package tookan.tookantrack.retrofit2;

import android.content.Context;

import java.lang.annotation.Annotation;

import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;

/**
 * TrackingErrorUtils
 */


public class TrackingErrorUtils {

    /**
     * @param response
     * @return
     */
    public static TrackingAPIError parseError(Response<?> response, Context context) {
        Converter<ResponseBody, TrackingAPIError> converter = TrackingRestClient.getRetrofitBuilder(context).responseBodyConverter(TrackingAPIError.class, new Annotation[0]);
        TrackingAPIError error;
        try {
            if (response.errorBody() != null) {//&& !converter.convert(response.errorBody()).isEmptyObject()
                error = converter.convert(response.errorBody());
            } else {
                error = new TrackingAPIError(response.code(), response.message());
            }

        } catch (Exception e) {
            int statusCode = 900;
            String message = TrackingResponseResolver.UNEXPECTED_ERROR_OCCURRED;
            if (response.code() != 0)
                statusCode = response.code();
            if (response.message() != null && !response.message().isEmpty())
                message = response.message();
            return new TrackingAPIError(statusCode, message);
        }
        return error;
    }
}
