package tookan.tookantrack.metering.datastructure;

import com.google.android.gms.maps.model.LatLng;

import tookan.tookantrack.metering.utils.MeteringUtils;

public class LatLngPair {

    public LatLng source, destination;
    public double deltaDistance;

    public LatLngPair(LatLng source, LatLng destination, double deltaDistance) {
        this.source = source;
        this.destination = destination;
        this.deltaDistance = deltaDistance;
    }

    @Override
    public boolean equals(Object o) {
        try {
            LatLngPair matchO = (LatLngPair) o;
            return ((MeteringUtils.compareDouble(matchO.source.latitude, this.source.latitude) == 0)
                    && (MeteringUtils.compareDouble(matchO.source.longitude, this.source.longitude) == 0)) ||
                    ((MeteringUtils.compareDouble(matchO.destination.latitude, this.destination.latitude) == 0)
                            && (MeteringUtils.compareDouble(matchO.destination.longitude, this.destination.longitude) == 0));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String toString() {
        // TODO Auto-generated method stub
        return source + " " + destination + " " + deltaDistance;
    }

}
