package tookan.tookantrack.metering.datastructure;

import com.google.android.gms.maps.model.LatLng;

/**
 * Developer: Rishabh
 * Dated: 6/12/15.
 */
public class CurrentPathItem {

    public long id;
    public long parentId;
    public LatLng sLatLng;
    public LatLng dLatLng;
    public double disp;
    public int sectionIncomplete;
    public int googlePath;
    public int acknowledged;

    public long colTimestamp;
    public int colIsMock;
    public double colAccuracy;
    public int colIsHighAccuracy;
    public int colSpeed;
    public double colAltitude;
    public int colInternetAvailable;
    public int colBatteryLevels;


    public CurrentPathItem(long id, long parentId, double slat, double slng, double dlat, double dlng,
                           double disp, int sectionIncomplete, int googlePath, int acknowledged,

                           long colTimestamp, int colIsMock, double colAccuracy, int colIsHighAccuracy,
                           int colSpeed, double colAltitude, int colInternetAvailable, int colBatteryLevels) {

        this.id = id;
        this.parentId = parentId;
        this.sLatLng = new LatLng(slat, slng);
        this.dLatLng = new LatLng(dlat, dlng);
        this.disp = disp;
        this.sectionIncomplete = sectionIncomplete;
        this.googlePath = googlePath;
        this.acknowledged = acknowledged;

        this.colTimestamp = colTimestamp;
        this.colIsMock = colIsMock;
        this.colAccuracy = colAccuracy;
        this.colIsHighAccuracy = colIsHighAccuracy;
        this.colSpeed = colSpeed;
        this.colAltitude = colAltitude;
        this.colInternetAvailable = colInternetAvailable;
        this.colBatteryLevels = colBatteryLevels;
    }

    @Override
    public boolean equals(Object o) {
        try {
            return this.id == ((CurrentPathItem) o).id;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String toString() {
        return id + ", " + parentId + ", " + sectionIncomplete + ", " + googlePath + ", " + acknowledged
                + ", " + colTimestamp + ", " + colIsMock + ", " + colAccuracy + ", " + colIsHighAccuracy
                + ", " + colSpeed + ", " + colAltitude + ", " + colInternetAvailable + ", " + colBatteryLevels;
    }
}
