package tookan.tookantrack.metering;

import android.app.AlarmManager;
import android.app.LauncherActivity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.SystemClock;
import android.service.notification.StatusBarNotification;

import tookan.tookantrack.R;
import tookan.tookantrack.metering.datastructure.SPLabels;
import tookan.tookantrack.metering.utils.Prefs;
import tookan.tookantrack.utils.TTLog;


public class MeteringService extends Service {

    public static final int UPLOAD_PATH_PI_REQUEST_CODE = 112;
    public static final String UPLOAD_PATH = "com.mapmeter.UPLOAD_PATH";
    public static final long ALARM_REPEAT_INTERVAL = 30000;
    private static final String TAG = MeteringService.class.getSimpleName();
    private static NotificationChannel notificationChannel;

    private PowerManager.WakeLock pWakeLock;


    public MeteringService() {
        TTLog.e("MeteringService", " instance created");
    }

    public static GpsDistanceCalculator gpsInstance(Context context) {
        return GpsDistanceCalculator.getInstance(context,
                GpsDistanceCalculator.getTotalDistanceFromSP(context),
                GpsDistanceCalculator.getLastLocationTimeFromSP(context),
                GpsDistanceCalculator.getTotalHaversineDistanceFromSP(context));
    }

    @Override
    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onStart(Intent intent, int startId) {

        TTLog.e(TAG, "onStart");
        PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
        pWakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "TOOKAN");
        pWakeLock.acquire();
        cancelAlarm();
        gpsInstance(this).start();
//        startUploadPathAlarm();

    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        TTLog.e(TAG, "onStartCommand");

        super.onStartCommand(intent, flags, startId);
        return Service.START_STICKY;
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {

        TTLog.e(TAG, "onTaskRemoved");

        restartServiceViaAlarm();
    }


    public void restartServiceViaAlarm() {

        TTLog.e(TAG, "restartServiceViaAlarm");


        try {
            gpsInstance(this).saveState();
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String meteringState = DatabaseMM.getInstance(this).getMetringState();
            String meteringStateSp = Prefs.with(this).getString(SPLabels.METERING_STATE, DatabaseMM.OFF);
            if (!DatabaseMM.ON.equalsIgnoreCase(meteringState) && !DatabaseMM.ON.equalsIgnoreCase(meteringStateSp)) {
                gpsInstance(this).stop();
                DatabaseMM.getInstance(this).deleteAllCurrentPathItems();
                //     cancelUploadPathAlarm();
            } else {
                Intent restartService = new Intent(getApplicationContext(), this.getClass());
                restartService.setPackage(getPackageName());
                PendingIntent restartServicePI = PendingIntent.getService(getApplicationContext(), 1, restartService, PendingIntent.FLAG_ONE_SHOT);
                AlarmManager alarmService = (AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE);
                alarmService.set(AlarmManager.ELAPSED_REALTIME, SystemClock.elapsedRealtime() + 1000, restartServicePI);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelAlarm() {

        TTLog.e(TAG, "cancelAlarm");

        try {
            Intent restartService = new Intent(getApplicationContext(), this.getClass());
            restartService.setPackage(getPackageName());
            PendingIntent restartServicePI = PendingIntent.getService(getApplicationContext(), 1, restartService, PendingIntent.FLAG_ONE_SHOT);
            AlarmManager alarmService = (AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE);
            alarmService.cancel(restartServicePI);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {

        TTLog.e(TAG, "onDestroy");

        // Release the CPU WakeLock, if acquired
        if (pWakeLock != null) pWakeLock.release();
        stopForeground(true);
        restartServiceViaAlarm();
    }

    private void startForegroundService() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            Intent notificationIntent = new Intent(this, LauncherActivity.class);
            PendingIntent pendingIntent =
                    PendingIntent.getActivity(this, 0, notificationIntent, 0);

            NotificationManager notificationManager =
                    (NotificationManager) getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
            if (notificationChannel == null) {
                notificationChannel = new NotificationChannel("metering_notification", "notification", NotificationManager.IMPORTANCE_HIGH);
            }
            String message = getString(R.string.tookan_agent_is_fetching_your_location);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(notificationChannel);
                StatusBarNotification[] statusBarNotifications = notificationManager.getActiveNotifications();
                for (StatusBarNotification statusBarNotification : statusBarNotifications) {
                    if (statusBarNotification.getId() == 1456) {
                        return;
                    }
                }
            }
            Notification notification =
                    new Notification.Builder(this)
                            .setSmallIcon(R.mipmap.ic_notif)
                            .setStyle(new Notification.BigTextStyle().bigText(message))
                            .setContentText(message)
                            .setContentIntent(pendingIntent)
                            .setChannelId("metering_notification")
                            .build();
            startForeground(1456, notification);
        }
    }
    }


