package tookan.tookantrack.metering;

import android.app.LauncherActivity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.support.v4.app.NotificationCompat;

import tookan.tookantrack.R;
import tookan.tookantrack.metering.datastructure.GpsState;
import tookan.tookantrack.metering.datastructure.SPLabels;
import tookan.tookantrack.metering.utils.Prefs;
import tookan.tookantrack.utils.TTLog;


public class MeteringAlarmReceiver extends BroadcastReceiver {

    private static final String CHECK_LOCATION = "com.mapmeter.CHECK_LOCATION";

    private static final long MINUTE = 60 * 1000;
    private static final long HALF_MINUTE = 30 * 1000;
    private static final long MAX_TIME_BEFORE_LOCATION_UPDATE = 2 * MINUTE;
    private static final int NOTIFICATION_ID = 2;
    private static long lastLocationTime = 0;

    public static void sendNotification(Context context) {

        // Using RemoteViews to bind custom layouts into Notification
//        RemoteViews remoteViews = new RemoteViews(activity.getPackageName(),
//                R.layout.custom_notification_layout);
        String message = "error in fetching location";
        final Intent notificationIntent = new Intent(context.getApplicationContext(), LauncherActivity.class);
        notificationIntent.setAction(Intent.ACTION_MAIN);
        notificationIntent.addCategory(Intent.CATEGORY_LAUNCHER);
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        PendingIntent contentIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0);

        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context)
                .setSmallIcon(R.drawable.cast_ic_notification_small_icon)
//                .setLargeIcon(getCircleBitmap(BitmapFactory.decodeResource(activity.getResources(),R.mipmap.ic_launcher)))
                .setContentTitle(context.getString(R.string.tracking_app_name))
                .setStyle(new NotificationCompat.BigTextStyle().bigText(message))
                .setColor(Color.RED)
                .setContentText(message);


//// Locate and set the Image into customnotificationtext.xml ImageViews
//        remoteViews.setImageViewResource(R.id.imagenotileft,R.mipmap.ic_launcher);
//        remoteViews.setImageViewResource(R.id.imagenotiright,R.drawable.location_icon);
//
//        // Locate and set the Text into customnotificationtext.xml TextViews
//        remoteViews.setTextViewText(R.id.title,activity.getString(R.string.app_name));
//        remoteViews.setTextViewText(R.id.text,message);
        mBuilder.setContentIntent(contentIntent);

        Notification notification = mBuilder.build();
        notification.flags = Notification.FLAG_ONGOING_EVENT;
        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.notify(NOTIFICATION_ID, notification);
    }

    /**
     * Method to cancel the notification from the
     * notification bar
     */
    public static void cancelNotification(Context context) {
        lastLocationTime = System.currentTimeMillis();
        String notificationService = Context.NOTIFICATION_SERVICE;
        NotificationManager notificationManager = (NotificationManager)
                context.getSystemService(notificationService);
        notificationManager.cancel(NOTIFICATION_ID);
    }

    @Override
    public void onReceive(final Context context, Intent intent) {
        try {
            String action = intent.getAction();
            if (CHECK_LOCATION.equals(action)) {
                long timeDiffernce = System.currentTimeMillis() - GpsDistanceCalculator.lastLocationTime;
                if (lastLocationTime > 0) {
                    long timeDiff = System.currentTimeMillis() - lastLocationTime;
                    TTLog.i("Time difference", "==" + timeDiff);
                    if (timeDiff >= 5 * MINUTE) {
                        sendNotification(context);
                    }
                }
                if (timeDiffernce >= 6 * MINUTE) {
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.GREATER_SIX.getOrdinal());
//                    Intent dialogIntent = new Intent(context, activity.getClass());
//                    dialogIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                    dialogIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
//                    context.startActivity(dialogIntent);
                    GpsDistanceCalculator.lastLocationTime = System.currentTimeMillis();
                    GpsDistanceCalculator.saveLastLocationTimeToSP(context, GpsDistanceCalculator.lastLocationTime);
//                    if (TrackingLocationUtils.isGPSEnabled(context)) {
//                        MeteringUtils.longToast(activity, activity.getString(R.string.app_restart_message));
//                    }

                } else if (timeDiffernce > 7 * HALF_MINUTE) {
                    if (Prefs.with(context).getInt(SPLabels.GPS_STATE, GpsState.ZERO_TWO.getOrdinal())
                            == GpsState.TWO_LESS_FOUR.getOrdinal()) {

//                        Intent i = new Intent(context, activity.getClass());
//                        i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                        i.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
//                        i.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
//                        context.startActivity(i);
                    } else {
                        GpsDistanceCalculator.gpsLocationUpdate.refreshLocationFetchers(context);
                    }
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.GREATER_FOUR.getOrdinal());
                } else if (timeDiffernce > MAX_TIME_BEFORE_LOCATION_UPDATE) {
                    GpsDistanceCalculator.gpsLocationUpdate.refreshLocationFetchers(context);
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.TWO_LESS_FOUR.getOrdinal());
                } else {
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.ZERO_TWO.getOrdinal());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}