package tookan.tookantrack.metering;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;

import com.google.android.gms.location.FusedLocationProviderApi;

import tookan.tookantrack.utils.TrackingLocationUtils;


public class FusedLocationReceiverBackgroundHigh extends BroadcastReceiver {

    private static final String TAG = FusedLocationReceiverBackgroundHigh.class.getSimpleName();


    @Override
    public void onReceive(final Context context, Intent intent) {

        final Location location = (Location) intent.getExtras().get(FusedLocationProviderApi.KEY_LOCATION_CHANGED);

        //TTLog.e(TAG, "onReceive: " + location);

        // Check if the Location is not null
        if (location != null) {

            // Save the Location to the SharedPreferences
            TrackingLocationUtils.saveLocation(context, location);

            if (GpsDistanceCalculator.gpsLocationUpdate != null)
                GpsDistanceCalculator.gpsLocationUpdate.onGPSLocationChanged(location);
        }
    }

}