package tookan.tookantrack.metering;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import java.util.ArrayList;

import tookan.tookantrack.metering.datastructure.CurrentPathItem;
import tookan.tookantrack.utils.TTLog;

/**
 * Handles database related work
 */
public class DatabaseMM {                                                                    // class for handling database related activities

    public static final String ON = "on", OFF = "off";
    private static final String DATABASE_NAME = "metermap_database";                        // declaring database variables

    private static final int DATABASE_VERSION = 2;
    private static final String TABLE_TOTAL_DISTANCE = "table_total_distance";
    private static final String TOTAL_DISTANCE = "total_distance";
    private static final String TABLE_METERING_STATE = "table_metering_state";
    private static final String METERING_STATE = "metering_state";
    // ***************** // table_current_path table columns  // **********************//
    private static final String TABLE_CURRENT_PATH = "table_current_path";
    private static final String ID = "id";
    private static final String PARENT_ID = "parent_id";
    private static final String SLAT = "slat";
    private static final String SLNG = "slng";
    private static final String DLAT = "dlat";
    private static final String DLNG = "dlng";
    private static final String DISP = "disp";
    private static final String SECTION_INCOMPLETE = "section_incomplete";
    private static final String GOOGLE_PATH = "google_path";
    private static final String ACKNOWLEDGED = "acknowledged";
    private static final String COL_TIMESTAMP = "timestamp";
    private static final String COL_IS_MOCK = "is_mock";
    private static final String COL_ACCURACY = "accuracy";
    private static final String COL_IS_HIGH_ACCURACY = "is_high_accuracy";
    private static final String COL_SPEED = "speed";
    private static final String COL_ALTITUDE = "altitude";
    private static final String COL_INTERNET_AVAILABLE = "is_internet_available";
    private static final String COL_BATTERY_LEVEL = "battery_level";
    private static DatabaseMM dbInstance;
    private DbHelper dbHelper;
    private SQLiteDatabase database;


    private DatabaseMM(Context context) {
        dbHelper = new DbHelper(context);
        database = dbHelper.getWritableDatabase();
        createAllTables(database);
    }

    private static void createAllTables(SQLiteDatabase database) {
        /****************************************** CREATING ALL THE TABLES *****************************************************/

        database.execSQL(" CREATE TABLE IF NOT EXISTS " + TABLE_TOTAL_DISTANCE + " ("
                + TOTAL_DISTANCE + " TEXT" + ");");

        database.execSQL(" CREATE TABLE IF NOT EXISTS " + TABLE_METERING_STATE + " ("
                + METERING_STATE + " TEXT" + ");");


        database.execSQL(" CREATE TABLE IF NOT EXISTS " + TABLE_CURRENT_PATH + " ("
                + ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
                + PARENT_ID + " INTEGER, "
                + SLAT + " REAL, "
                + SLNG + " REAL, "
                + DLAT + " REAL, "
                + DLNG + " REAL, "
                + DISP + " REAL, "
                + SECTION_INCOMPLETE + " INTEGER, "
                + GOOGLE_PATH + " INTEGER, "
                + ACKNOWLEDGED + " INTEGER, "
                + COL_TIMESTAMP + " INT8, "
                + COL_IS_MOCK + " INTEGER, "
                + COL_ACCURACY + " REAL,"
                + COL_IS_HIGH_ACCURACY + " INTEGER,"
                + COL_SPEED + " REAL,"
                + COL_ALTITUDE + " REAL,"
                + COL_INTERNET_AVAILABLE + " INTEGER,"
                + COL_BATTERY_LEVEL + " INTEGER"
                + ");");

    }

    public static DatabaseMM getInstance(Context context) {
        if (dbInstance == null) {
            dbInstance = new DatabaseMM(context);
        } else if (!dbInstance.database.isOpen()) {
            dbInstance = null;
            dbInstance = new DatabaseMM(context);
        }
        return dbInstance;
    }

    public void close() {
        database.close();
        dbHelper.close();
        System.gc();
    }

    public double getTotalDistance() {
        double totaldistance = 0;
        try {
            String[] columns = new String[]{DatabaseMM.TOTAL_DISTANCE};
            Cursor cursor = database.query(DatabaseMM.TABLE_TOTAL_DISTANCE, columns, null, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                totaldistance = Double.parseDouble(cursor.getString(cursor.getColumnIndex(DatabaseMM.TOTAL_DISTANCE)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return totaldistance;
    }

    public void updateTotalDistance(double totalDistance) {
        try {
            deleteTotalDistance();
            ContentValues contentValues = new ContentValues();
            contentValues.put(DatabaseMM.TOTAL_DISTANCE, totalDistance);
            database.insert(DatabaseMM.TABLE_TOTAL_DISTANCE, null, contentValues);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int deleteTotalDistance() {
        try {
            return database.delete(DatabaseMM.TABLE_TOTAL_DISTANCE, null, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String getMetringState() {
        String[] columns = new String[]{DatabaseMM.METERING_STATE};
        Cursor cursor = database.query(DatabaseMM.TABLE_METERING_STATE, columns, null, null, null, null, null);
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            String choice = cursor.getString(cursor.getColumnIndex(DatabaseMM.METERING_STATE));
            return choice;
        } else {
            return OFF;
        }
    }

    public int updateMetringState(String choice) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(DatabaseMM.METERING_STATE, choice);
            int rowsAffected = database.update(DatabaseMM.TABLE_METERING_STATE, contentValues, null, null);
            if (rowsAffected == 0) {
                database.insert(DatabaseMM.TABLE_METERING_STATE, null, contentValues);
                return 1;
            } else {
                return rowsAffected;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public long insertCurrentPathItem(long parentId, double slat, double slng, double dlat, double dlng, double disp,
                                      int sectionIncomplete, int googlePath,
                                      long timeStamp, int isMock, double accuracy, int isHighAccuracy,
                                      double speed, double altitude, int isInternet, int batteryLevel) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(PARENT_ID, parentId);
            contentValues.put(SLAT, slat);
            contentValues.put(SLNG, slng);
            contentValues.put(DLAT, dlat);
            contentValues.put(DLNG, dlng);
            contentValues.put(DISP, disp);
            contentValues.put(SECTION_INCOMPLETE, sectionIncomplete);
            contentValues.put(GOOGLE_PATH, googlePath);
            contentValues.put(ACKNOWLEDGED, 0);

            contentValues.put(COL_TIMESTAMP, timeStamp);
            contentValues.put(COL_IS_MOCK, isMock);
            contentValues.put(COL_ACCURACY, accuracy);
            contentValues.put(COL_IS_HIGH_ACCURACY, isHighAccuracy);
            contentValues.put(COL_SPEED, speed);
            contentValues.put(COL_ALTITUDE, altitude);
            contentValues.put(COL_INTERNET_AVAILABLE, isInternet);
            contentValues.put(COL_BATTERY_LEVEL, batteryLevel);

            return database.insert(TABLE_CURRENT_PATH, null, contentValues);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }


//        + ID + " INTEGER PRIMARY KEY AUTOINCREMENT, "
//        + PARENT_ID + " INTEGER, "
//        + SLAT + " REAL, "
//        + SLNG + " REAL, "
//        + DLAT + " REAL, "
//        + DLNG + " REAL, "
//        + SECTION_INCOMPLETE + " INTEGER, "
//        + GOOGLE_PATH + " INTEGER, "
//        + ACKNOWLEDGMENT_PENDING + " INTEGER"


    //------- Current path table

    public int updateCurrentPathItemSectionIncomplete(long rowId, int sectionIncomplete) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(SECTION_INCOMPLETE, sectionIncomplete);
            int rowsAffected = database.update(TABLE_CURRENT_PATH, contentValues, ID + "=" + rowId, null);
            return rowsAffected;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateCurrentPathItemSectionIncompleteAndGooglePath(long rowId, int sectionIncomplete, int googlePath) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(SECTION_INCOMPLETE, sectionIncomplete);
            contentValues.put(GOOGLE_PATH, googlePath);
            int rowsAffected = database.update(TABLE_CURRENT_PATH, contentValues, ID + "=" + rowId, null);
            return rowsAffected;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateCurrentPathItemAcknowledged(long rowId, int acknowledged) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(ACKNOWLEDGED, acknowledged);
            int rowsAffected = database.update(TABLE_CURRENT_PATH, contentValues, ID + "=" + rowId, null);
            return rowsAffected;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateCurrentPathItemAcknowledgedForArray(ArrayList<Long> rowId, int acknowledged) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(ACKNOWLEDGED, acknowledged);
            int rowsAffected = database.update(TABLE_CURRENT_PATH, contentValues, ID + " in(" + rowId.toString().substring(1, rowId.toString().length() - 1) + ")", null);
            TTLog.e("rowsAffected", "=" + rowsAffected);
            return rowsAffected;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public ArrayList<CurrentPathItem> getCurrentPathItemsSaved() {
        ArrayList<CurrentPathItem> currentPathItems = new ArrayList<CurrentPathItem>();
        try {
            String[] columns = new String[]{ID, PARENT_ID, SLAT, SLNG, DLAT, DLNG, DISP, SECTION_INCOMPLETE, GOOGLE_PATH, ACKNOWLEDGED,
                    COL_TIMESTAMP, COL_IS_MOCK, COL_ACCURACY, COL_IS_HIGH_ACCURACY,
                    COL_SPEED, COL_ALTITUDE, COL_INTERNET_AVAILABLE, COL_BATTERY_LEVEL};

            Cursor cursor = database.query(TABLE_CURRENT_PATH, columns, null, null, null, null, null);
            currentPathItems.addAll(getCurrentPathItemsFromCursor(cursor));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return currentPathItems;
    }

    public ArrayList<CurrentPathItem> getCurrentPathItemsToUpload() {
        ArrayList<CurrentPathItem> currentPathItems = new ArrayList<CurrentPathItem>();
        try {
            String[] columns = new String[]{ID, PARENT_ID, SLAT, SLNG, DLAT, DLNG, DISP, SECTION_INCOMPLETE, GOOGLE_PATH, ACKNOWLEDGED,
                    COL_TIMESTAMP, COL_IS_MOCK, COL_ACCURACY, COL_IS_HIGH_ACCURACY,
                    COL_SPEED, COL_ALTITUDE, COL_INTERNET_AVAILABLE, COL_BATTERY_LEVEL};

            Cursor cursor = database.query(TABLE_CURRENT_PATH, columns, ACKNOWLEDGED + "=0", null, null, null, null);
            currentPathItems.addAll(getCurrentPathItemsFromCursor(cursor));
            if (currentPathItems.size() > 900) {
                currentPathItems.clear();
                currentPathItems.addAll(getCurrentPathItemsFromCursor(cursor).subList(0, 900));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return currentPathItems;
    }

    public ArrayList<CurrentPathItem> getCurrentPathItemsFromCursor(Cursor cursor) {
        ArrayList<CurrentPathItem> currentPathItems = new ArrayList<CurrentPathItem>();
        try {
            if (cursor.getCount() > 0) {
                int in0 = cursor.getColumnIndex(ID);
                int in1 = cursor.getColumnIndex(PARENT_ID);
                int in2 = cursor.getColumnIndex(SLAT);
                int in3 = cursor.getColumnIndex(SLNG);
                int in4 = cursor.getColumnIndex(DLAT);
                int in5 = cursor.getColumnIndex(DLNG);
                int in6 = cursor.getColumnIndex(SECTION_INCOMPLETE);
                int in7 = cursor.getColumnIndex(GOOGLE_PATH);
                int in8 = cursor.getColumnIndex(ACKNOWLEDGED);
                int in9 = cursor.getColumnIndex(DISP);

                int in10 = cursor.getColumnIndex(COL_TIMESTAMP);
                int in11 = cursor.getColumnIndex(COL_IS_MOCK);
                int in12 = cursor.getColumnIndex(COL_ACCURACY);
                int in13 = cursor.getColumnIndex(COL_IS_HIGH_ACCURACY);
                int in14 = cursor.getColumnIndex(COL_SPEED);
                int in15 = cursor.getColumnIndex(COL_ALTITUDE);
                int in16 = cursor.getColumnIndex(COL_INTERNET_AVAILABLE);
                int in17 = cursor.getColumnIndex(COL_BATTERY_LEVEL);


                int currentCursorPosition = -1;
                long parentId = 0;
                for (cursor.moveToFirst(); !cursor.isAfterLast(); cursor.moveToNext()) {
                    try {
                        if (0 == cursor.getInt(in6)) {
                            CurrentPathItem currentPathItem = new CurrentPathItem(cursor.getLong(in0),
                                    cursor.getLong(in1),
                                    cursor.getDouble(in2),
                                    cursor.getDouble(in3),
                                    cursor.getDouble(in4),
                                    cursor.getDouble(in5),
                                    cursor.getDouble(in9),
                                    cursor.getInt(in6),
                                    cursor.getInt(in7),
                                    cursor.getInt(in8),

                                    cursor.getLong(in10),
                                    cursor.getInt(in11),
                                    cursor.getInt(in12),
                                    cursor.getInt(in13),
                                    cursor.getInt(in14),
                                    cursor.getInt(in15),
                                    cursor.getInt(in16),
                                    cursor.getInt(in17)


                            );

                            if (-1 == currentPathItem.parentId) {
                                currentPathItems.add(currentPathItem);
                            }

                            if (1 == currentPathItem.googlePath) {
                                parentId = currentPathItem.id;
                                currentCursorPosition = cursor.getPosition();
                                for (cursor.moveToPosition(currentCursorPosition); !cursor.isAfterLast(); cursor.moveToNext()) {
                                    try {
                                        if (0 == cursor.getInt(in6)) {
                                            CurrentPathItem currentPathItemChild = new CurrentPathItem(cursor.getLong(in0),
                                                    cursor.getLong(in1),
                                                    cursor.getDouble(in2),
                                                    cursor.getDouble(in3),
                                                    cursor.getDouble(in4),
                                                    cursor.getDouble(in5),
                                                    cursor.getDouble(in9),
                                                    cursor.getInt(in6),
                                                    cursor.getInt(in7),
                                                    cursor.getInt(in8),

                                                    cursor.getLong(in10),
                                                    cursor.getInt(in11),
                                                    cursor.getInt(in12),
                                                    cursor.getInt(in13),
                                                    cursor.getInt(in14),
                                                    cursor.getInt(in15),
                                                    cursor.getInt(in16),
                                                    cursor.getInt(in17));
                                            if (parentId == currentPathItemChild.parentId) {
                                                currentPathItems.add(currentPathItemChild);
                                            }
                                        } else {
                                            break;
                                        }
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                cursor.moveToPosition(currentCursorPosition);
                            } else {
                            }
                        } else {
                            break;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return currentPathItems;
    }

    public void deleteAllCurrentPathItems() {
        try {
            if (getCurrentPathItemsToUpload().size() < 800 && !getCurrentPathItemsToUpload().isEmpty())
                return;
            database.delete(DatabaseMM.TABLE_CURRENT_PATH, null, null);
            database.execSQL("DROP TABLE " + DatabaseMM.TABLE_CURRENT_PATH);
            createAllTables(database);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Creates and opens database for the application use
     *
     * @author shankar
     */
    private static class DbHelper extends SQLiteOpenHelper {

        public DbHelper(Context context) {
            super(context, DATABASE_NAME, null, DATABASE_VERSION);
        }

        @Override
        public void onCreate(SQLiteDatabase database) {
            DatabaseMM.createAllTables(database);
        }

        @Override
        public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
            onCreate(database);
        }

    }


}