package tookan.tookantrack.activity;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;

import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;

import tookan.tookantrack.R;
import tookan.tookantrack.TookanLocationTracking;
import tookan.tookantrack.TookanTrack;
import tookan.tookantrack.metering.LocationFetcher;
import tookan.tookantrack.utils.TTConstants;
import tookan.tookantrack.retrofit2.TrackingCodes;
import tookan.tookantrack.utils.LocationAccess;
import tookan.tookantrack.utils.TrackingLocationUtils;


public class HomeActivity extends AppCompatActivity implements OnMapReadyCallback, LocationFetcher.OnLocationChangedListener {
    private TookanLocationTracking tookantracker;

    private GoogleMap mMap;
    private Marker marker;
    private boolean firstLocation;
    private Location lastLocation;
    private RelativeLayout rlMyLocation;
    private LocationFetcher locationFetcher;
    private TookanLocationTracking tookanInstance;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_home);
        rlMyLocation = findViewById(R.id.rlMyLocation);
        firstLocation = true;
        rlMyLocation.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                moveToCurrentPosition();
            }
        });
        SupportMapFragment mapFragment = (SupportMapFragment) getSupportFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync(this);
        startLocationFetcher();
    }

    public void animateMarker(final Marker marker, final LatLng toPosition) {
        final Handler handler = new Handler();
        final long start = SystemClock.uptimeMillis();
        Projection proj = mMap.getProjection();
        Point startPoint = proj.toScreenLocation(marker.getPosition());
        final LatLng startLatLng = proj.fromScreenLocation(startPoint);
        final long duration = 500;
        final Interpolator interpolator = new LinearInterpolator();
        handler.post(new Runnable() {
            @Override
            public void run() {
                long elapsed = SystemClock.uptimeMillis() - start;
                try {
                    float t = interpolator.getInterpolation((float) elapsed
                            / duration);
                    double lng = t * toPosition.longitude + (1 - t)
                            * startLatLng.longitude;
                    double lat = t * toPosition.latitude + (1 - t)
                            * startLatLng.latitude;
                    marker.setPosition(new LatLng(lat, lng));
                    if (t < 1.0) {
                        // Post again 16ms later.
                        handler.postDelayed(this, 16);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onMapReady(GoogleMap googleMap) {
        mMap = googleMap;
        if (mMap != null) {
            if (TrackingLocationUtils.checkLocationPermissions(this)) {
                try {
                    this.mMap.setMyLocationEnabled(true);
                } catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            mMap.getUiSettings().setMyLocationButtonEnabled(false);
            mMap.getUiSettings().setCompassEnabled(false);
            mMap.setMapStyle(MapStyleOptions.loadRawResourceStyle(this, R.raw.map_style));

        }
    }

    /**
     * Method to start the Location Fetcher
     */
    private void startLocationFetcher() {

        if (!TrackingLocationUtils.checkLocationPermissions(this)) return;

        // Start fetching the location
        if (locationFetcher == null)
            locationFetcher = new LocationFetcher(HomeActivity.this,
                    TTConstants.TimeRange.LOCATION_FETCH_INTERVAL,
                    TTConstants.LocationPriority.BEST);

            // connect the existing location fetcher
        else locationFetcher.connect();
    }

    @Override
    public void onLocationChanged(Location location, int priority) {


        if (location == null)
            return;

        // Check if no location is fetched
        if (location.getLatitude() == 0 && location.getLongitude() == 0) return;
        TrackingLocationUtils.saveLocation(this, location);
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {


        switch (requestCode) {

            case TrackingCodes.Permission.LOCATION:

                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED)
                    startLocationFetcher();
                    moveToCurrentPosition();
                break;

        }
    }

    private void moveToCurrentPosition() {
        LatLng currentLatLng = new LatLng(TookanTrack.getLastLocation(this).getLatitude(), TookanTrack.getLastLocation(this).getLongitude());
        CameraPosition cameraPosition = new CameraPosition.Builder().target(currentLatLng).zoom(13).tilt(41.25f).build();

        mMap.animateCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
    }

}
