package tookan.tookantrack;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.util.Log;

import com.google.android.gms.maps.GoogleMap;

import tookan.tookantrack.activity.HomeActivity;
import tookan.tookantrack.model.TrackingData;
import tookan.tookantrack.retrofit2.TrackingAPIError;
import tookan.tookantrack.retrofit2.TrackingCommonParams;
import tookan.tookantrack.retrofit2.TrackingResponseResolver;
import tookan.tookantrack.retrofit2.TrackingRestClient;
import tookan.tookantrack.utils.LocationAccess;
import tookan.tookantrack.utils.TrackingDependencies;
import tookan.tookantrack.utils.TrackingLocationUtils;
import tookan.tookantrack.utils.TrackingNetworkUtils;

/**
 * Created by shubhamsoni on 23/11/17.
 */

public class TookanTrackImpl {
    private static TookanTrackImpl sInstance;
    private static TookanLocationTracking tookanInstance;


    public static TookanTrackImpl getInstance() {
        if (sInstance == null) {
            sInstance = new TookanTrackImpl();
        }

        return sInstance;
    }



    public void initialize(Activity context, String apikey, String userid) {
        TrackingDependencies.saveKey(context, apikey);
        TrackingDependencies.saveUserId(context, userid);
    }

    public void startTracking(final Activity context) {

        TrackingCommonParams trackingCommonParams = new TrackingCommonParams.Builder()
                .add("api_key", TrackingDependencies.getKey(context))
                .add("unique_user_id", TrackingDependencies.getUserId(context))
                .add("lat", TrackingLocationUtils.LATITUDE)
                .add("lng", TrackingLocationUtils.LONGITUDE)
                .build();
        Log.e("create session request","api_key"+TrackingDependencies.getKey(context)+"unique_user_id :"+TrackingDependencies.getUserId(context)+"lat :"+ TrackingLocationUtils.LATITUDE+"lng :"+TrackingLocationUtils.LONGITUDE);

        TrackingRestClient.getApiInterface(context).createSession(trackingCommonParams.getMap()).enqueue(new TrackingResponseResolver<TrackingData>((Activity) context, true, true) {
            @Override
            public void success(TrackingData trackingData) {
                TookanTrack.saveSessionId(context, trackingData.getData().getSessionId());
                startLocationSharing(context);
            }

            @Override
            public void failure(TrackingAPIError error) {
            }
        });
    }

    public void startTrackingBySdkInterface(Activity context) {
        Intent intent = new Intent(context, HomeActivity.class);
        context.startActivity(intent);
    }

    public void startLocationSharing(Activity context) {
        if (tookanInstance == null) {
            tookanInstance = TookanLocationTracking.getInstance(context);
        }
        tookanInstance.stopLocationTracking(context);
        tookanInstance.startLocationTracking(context);
    }


    public String getAPIKey(Activity context) {
    return TrackingDependencies.getKey(context);
    }

    public String getUserID(Activity context)
    {
        return TrackingDependencies.getUserId(context);
    }

    public String getSessionID(Activity context){
        return TrackingDependencies.getSessionId(context);
    }
    public void saveSessionID(Activity context,String sessionId){
    TrackingDependencies.saveSessionId(context,sessionId);
    }

    public void showImproveAccuracyDialog(Activity activity, GoogleMap googleMap){
        LocationAccess.showImproveAccuracyDialog(activity,googleMap);
    }

    public  boolean internetCheck(Activity activity){
        return  TrackingNetworkUtils.internetCheck(activity);
    }

    public  boolean isPlayServicesAvailable(Context context) {
        return TrackingLocationUtils.isPlayServicesAvailable((Activity) context);
    }

    public  boolean checkLocationPermissions(Activity activity){
        return TrackingLocationUtils.checkLocationPermissions(activity);
    }

    public  boolean isNetworkEnabled(Activity activity){
        return TrackingLocationUtils.isNetworkEnabled(activity);
    }
    public  boolean isGPSEnabled(Activity activity){
        return TrackingLocationUtils.isGPSEnabled(activity);
    }

    public  boolean isMockLocationsEnabled(Activity activity){
        return TrackingLocationUtils.isMockLocationsEnabled(activity);
    }

    public  Location getLastLocation(Activity activity){
        return TrackingLocationUtils.getLastLocation(activity);
    }
}
