package tookan.tookantrack;

import android.app.Activity;
import android.content.Context;
import android.location.Location;

import com.google.android.gms.maps.GoogleMap;


public class TookanTrack {


    public static  void initialize(Context context, String apikey, String userid) {
        TookanTrackImpl.getInstance().initialize((Activity) context, apikey, userid);
    }

    public static void startTracking(final Activity context) {
        TookanTrackImpl.getInstance().startTracking(context);
    }

    public static void startTrackingBySdkInterface(Context context) {
        TookanTrackImpl.getInstance().startTrackingBySdkInterface((Activity) context);
    }

    public static boolean isPlayServicesAvailable(Context context) {
        return TookanTrackImpl.getInstance().isPlayServicesAvailable((Activity) context);
    }

    public static boolean checkLocationPermissions(Activity activity){
        return TookanTrackImpl.getInstance().checkLocationPermissions(activity);
    }

    public static boolean isNetworkEnabled(Activity activity){
        return TookanTrackImpl.getInstance().isNetworkEnabled(activity);
    }
    public static boolean isGPSEnabled(Activity activity){
        return TookanTrackImpl.getInstance().isGPSEnabled(activity);
    }

    public static boolean isMockLocationsEnabled(Activity activity){
        return TookanTrackImpl.getInstance().isMockLocationsEnabled(activity);
    }

    public static Location getLastLocation(Activity activity){
        return TookanTrackImpl.getInstance().getLastLocation(activity);
    }

    public static void showImproveAccuracyDialog(Activity activity, GoogleMap googleMap){
     TookanTrackImpl.getInstance().showImproveAccuracyDialog(activity,googleMap);
      }

    public static boolean internetCheck(Activity activity){
      return  TookanTrackImpl.getInstance().internetCheck(activity);
    }

    public static String getAPIKey(Activity context) {
        return TookanTrackImpl.getInstance().getAPIKey(context);
    }

    public static String getUserID(Activity context) {
        return TookanTrackImpl.getInstance().getUserID(context);

    }

    public static String getSessionID(Activity context){
        return TookanTrackImpl.getInstance().getSessionID(context);
    }

    public static void saveSessionId(Activity context,String sessionId){
        TookanTrackImpl.getInstance().saveSessionID(context,sessionId);
    }

}
