package tookan.tookantrack;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;

import tookan.tookantrack.metering.Keys;
import tookan.tookantrack.metering.Meter;
import tookan.tookantrack.metering.utils.Prefs;
import tookan.tookantrack.utils.TTLog;
import tookan.tookantrack.utils.TrackingLocationUtils;


/**
 * Created by cl-macmini-83 on 28/07/16.
 */
public class TookanLocationTrackingImpl extends TookanLocationTracking {

    Meter meter;

    public TookanLocationTrackingImpl(Context context) {
        this.meter = new Meter(context);
        Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, false);
    }

    public static boolean arePermissionsEnabled(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        } else if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == PackageManager.PERMISSION_GRANTED) {
            return true;
        } else {
            TTLog.w("Location sdk error", "Please verify permissions. Have you enabled the required permissions ? ACCESS_FINE_LOCATION permission not granted.");
            return false;
        }
    }

    @Override
    public void startLocationTracking(Context context) {
        if (arePermissionsEnabled(context)) {
            if (meter == null) {
                meter = new Meter(context);
            }
            meter.start();
//            authenticateKeys(context,TookanLocationTracking.getAccessToken(context),TookanLocationTracking.getKey(context));
        }

    }

    @Override
    public void setLocationMode(Context context, int locationMode) {
        Prefs.with(context).save(Keys.Prefs.TOOKAN_LOCATION_MODE, locationMode);
    }

    @Override
    public void stopLocationTracking(Context context) {
        if (this.meter == null) {
            this.meter = new Meter(context);
        }
        this.meter.stop();
    }

    @Override
    public Location getCurrentLocation(Context context) {
        return TrackingLocationUtils.getLastLocation(context);
    }


}
