package tookan.tookantrack;

import android.content.Context;
import android.location.Location;

import tookan.tookantrack.metering.Keys;
import tookan.tookantrack.metering.utils.Prefs;

/**
 * Created by cl-macmini-83 on 21/07/16.
 */
public abstract class TookanLocationTracking {


    private static TookanLocationTrackingImpl sInstance;

    public TookanLocationTracking() {
    }

    public static TookanLocationTracking getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new TookanLocationTrackingImpl(context);
        }
        return sInstance;
    }

    /**
     * Method to save Access Token
     *
     * @param accessToken
     */
    public static void saveAccessToken(Context context, String accessToken) {

        Prefs.with(context).save(Keys.Prefs.ACCESS_TOKEN, accessToken);
    }

    /**
     * Extracts access_token of user from shared preferences
     *
     * @param context
     * @return access_token if exists else
     */
    public static String getAccessToken(Context context) {

        return Prefs.with(context).getString(Keys.Prefs.ACCESS_TOKEN, TookanLocationMode.EMPTY_STRING);
    }

    /**
     * Method to save Access Token
     *
     * @param accessToken
     */
    public static void saveKey(Context context, String accessToken) {

        Prefs.with(context).save(Keys.Prefs.KEY, accessToken);
    }

    /**
     * Extracts access_token of user from shared preferences
     *
     * @param context
     * @return access_token if exists else
     */
    public static String getKey(Context context) {

        return Prefs.with(context).getString(Keys.Prefs.KEY, TookanLocationMode.EMPTY_STRING);
    }

    /**
     * Method to retrieve the Location Fetch and Update mode
     *
     * @param context
     * @return
     */
    public static TookanLocationMode.LocationMode getLocationMode(Context context) {

        int locationModeType = Prefs.with(context).getInt(Keys.Prefs.TOOKAN_LOCATION_MODE, 1);
        return TookanLocationMode.LocationMode.getLocationMode(locationModeType);
    }

    public abstract void startLocationTracking(Context context);

    public abstract void setLocationMode(Context context, int locationMode);

    public abstract void stopLocationTracking(Context context);

    public abstract Location getCurrentLocation(Context context);

}
