package tookan.tookanlocationtrackinglibrary.metering;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.widget.Toast;

import tookan.tookanlocationtrackinglibrary.metering.datastructure.GpsState;
import tookan.tookanlocationtrackinglibrary.metering.datastructure.SPLabels;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;
import tookan.tookanlocationtrackinglibrary.metering.utils.Utils;


/**
 * Developer: Rishabh
 * Dated: 11/24/15.
 */
public class Meter {

    private static final String TAG = Meter.class.getSimpleName();

    private Context context;

    public Meter(Context context) {
        this.context = context;
    }

    public void start() {
        initializeStartRideVariables(1);
    }

    public void resume() {
        startMeteringService(Prefs.with(context).getInt(SPLabels.METER_START, 0));
    }

    public void stop() {
        displayFinalTotalDistance();
    }


    private void initializeStartRideVariables(int on) {

        /** Deletes the Cache */
        Utils.deleteCache(context);

        DatabaseMM.getInstance(context).deleteAllCurrentPathItems();

//        GpsDistanceCalculator.saveEngagementIdToSP(context, "Temp");

        /** Stop the Metering Service */
        MeteringService.gpsInstance(context).stop();

        /** Start the Metering Service */
        startMeteringService(on);
    }

    private void startMeteringService(int on) {

        Log.e(TAG, "startMeteringService: " + on);

        if (on == 1) {

            String meteringState = DatabaseMM.getInstance(context).getMetringState();
            String meteringStateSp = Prefs.with(context).getString(SPLabels.METERING_STATE, DatabaseMM.OFF);

            if (!DatabaseMM.ON.equalsIgnoreCase(meteringState) && !DatabaseMM.ON.equalsIgnoreCase(meteringStateSp)) {
                GpsDistanceCalculator.saveTrackingToSP(context, 0);
            }

            int rowsAffected = DatabaseMM.getInstance(context).updateMetringState(DatabaseMM.ON);
            Log.e(TAG, "rowsAffected: " + rowsAffected);
            Prefs.with(context).save(SPLabels.METERING_STATE, DatabaseMM.ON);
            if (rowsAffected > 0) {
                /** Start the Metering Service */
                context.startService(new Intent(context, MeteringService.class));

                Prefs.with(context).save(SPLabels.METER_START, 1);
            } else {
                Toast.makeText(context, "Some error occurred", Toast.LENGTH_SHORT).show();
            }
        } else {

            int rowsAffected = DatabaseMM.getInstance(context).updateMetringState(DatabaseMM.OFF);
            Prefs.with(context).save(SPLabels.METERING_STATE, DatabaseMM.OFF);

            if (rowsAffected > 0) {

                /** Stop the Meter and stop the Service */
                context.stopService(new Intent(context, MeteringService.class));
                Prefs.with(context).save(SPLabels.METER_START, 0);

            } else {
                Toast.makeText(context, "Some error occurred", Toast.LENGTH_SHORT).show();
            }

            Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.ZERO_TWO.getOrdinal());
        }
    }

    private void displayFinalTotalDistance() {
        initializeStartRideVariables(0);
    }
}
