package tookan.tookanlocationtrackinglibrary.metering;

import android.Manifest;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.app.ActivityCompat;
import android.util.Log;


import tookan.tookanlocationtrackinglibrary.TookanLocationMode;
import tookan.tookanlocationtrackinglibrary.TookanLocationTracking;
import tookan.tookanlocationtrackinglibrary.metering.datastructure.CurrentPathItem;
import tookan.tookanlocationtrackinglibrary.metering.datastructure.SPLabels;
import tookan.tookanlocationtrackinglibrary.metering.utils.HttpRequester;
import tookan.tookanlocationtrackinglibrary.metering.utils.MapUtils;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;
import tookan.tookanlocationtrackinglibrary.metering.utils.Utils;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptions;


import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import tookan.tookanlocationtrackinglibrary.location.LocationUtils;
import tookan.tookanlocationtrackinglibrary.metering.datastructure.LatLngPair;
import tookan.tookanlocationtrackinglibrary.metering.interfaces.FusedLocationUpdate;
import tookan.tookanlocationtrackinglibrary.metering.interfaces.GPSLocationUpdate;


public class GpsDistanceCalculator {

    public static final double MAX_SPEED_THRESHOLD = 2300; //in meters per second
    public static final double MAX_ACCURACY = 200;
    private static final double MAX_DISPLACEMENT_THRESHOLD = 200; //in meters
    private double MIN_DISTANCE=0;//in meters
    private static final String CHECK_LOCATION = "com.mapmeter.CHECK_LOCATION";

    private static final long ALARM_REPEAT_INTERVAL = 30000;

    private static final String TAG = GpsDistanceCalculator.class.getSimpleName();

    public static long lastLocationTime;
    public static GPSLocationUpdate gpsLocationUpdate;
    public static FusedLocationUpdate fusedLocationUpdate;
    private static GpsDistanceCalculator instance;

    private static long LOCATION_REFRESH_INTERVAL=1000;// = 2000; // in milliseconds

    private static int METERING_PI_REQUEST_CODE = 112;
    public double totalDistance;
    public double totalHaversineDistance;
    public Location lastGPSLocation, lastFusedLocation, gsmLocation;
    private double accumulativeSpeed;
    private int speedCounter;
    private long lastWaitWindowTime;
    private FusedLocationFetcherBackgroundHigh gpsForegroundLocationFetcher;
    private FusedLocationFetcherBackgroundBalanced fusedLocationFetcherBackgroundBalanced;
    private Context context;
    private LocationManager gsmManager;
    private MqttAndroidClient mqttAndroidClient;
    LocationListener GSMListener = new LocationListener() {

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }

        @Override
        public void onLocationChanged(Location location) {

            Log.e(TAG, "GSMListener -> onLocationChanged: " + location);

            if (location == null) return;


            LocationUtils.saveLocation(context, location);



            if (12 == (Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0))) {
                if (ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                        && ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                    // TODO: Consider calling
                    //    ActivityCompat#requestPermissions
                    // here to request the missing permissions, and then overriding
                    //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
                    //                                          int[] grantResults)
                    // to handle the case where the user grants the permission. See the documentation
                    // for ActivityCompat#requestPermissions for more details.
                    return;
                }

                gsmManager.removeUpdates(GSMListener);
                gsmManager = null;

                Prefs.with(context).save(SPLabels.GPS_GSM_DISTANCE_COUNT, Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0) + 1);
            }

            gsmLocation = location;
        }
    };

    private ArrayList<LatLngPair> deltaLatLngPairs = new ArrayList<>();
    private ArrayList<DirectionsAsyncTask> directionsAsyncTasks = new ArrayList<>();


    private GpsDistanceCalculator(Context context, double totalDistance, long lastLocationTime, double totalHaversineDistance) {

        Log.e(TAG, "GpsDistanceCalculator constructor");

        LOCATION_REFRESH_INTERVAL = TookanLocationTracking.getLocationMode(context).getLocationRefreshFrequency()*1000;
        MIN_DISTANCE = TookanLocationTracking.getLocationMode(context).getMinDistance();
        Log.e(TAG, "LOCATION_REFRESH_INTERVAL = " + LOCATION_REFRESH_INTERVAL);

        this.context = context;
        this.totalDistance = totalDistance;
        this.lastGPSLocation = null;
        this.totalHaversineDistance = totalHaversineDistance;
        this.lastFusedLocation = null;
        this.lastLocationTime = lastLocationTime;
        this.deltaLatLngPairs = new ArrayList<>();
        this.directionsAsyncTasks = new ArrayList<>();

        this.accumulativeSpeed = 0;
        this.speedCounter = 0;
        this.lastWaitWindowTime = System.currentTimeMillis();

        disconnectGPSListener();
        this.gpsForegroundLocationFetcher = null;
        this.fusedLocationFetcherBackgroundBalanced = null;
        initializeGPSForegroundLocationFetcher(context);


        Log.e("GpsDistanceCalculator ", "=totalDistance=" + totalDistance);
    }

    public static GpsDistanceCalculator getInstance(Context context, double totalDistance,
                                                    long lastLocationTime, double totalHaversineDistance) {

        Log.e(TAG, "getInstance");
        Log.e(TAG, "LOCATION_REFRESH_INTERVAL = " + LOCATION_REFRESH_INTERVAL);

        if (instance == null) {
            instance = new GpsDistanceCalculator(context, totalDistance, lastLocationTime, totalHaversineDistance);
        }

        instance.context = context;
        instance.totalDistance = totalDistance;
        instance.totalHaversineDistance = totalHaversineDistance;
        instance.lastLocationTime = lastLocationTime;

        return instance;
    }

    public static GpsDistanceCalculator getInstance(Context context) {

        if (instance == null) {
            instance = new GpsDistanceCalculator(context, getTotalDistanceFromSP(context), getLastLocationTimeFromSP(context), getTotalHaversineDistanceFromSP(context));
        }

        instance.context = context;
        instance.totalDistance = getLastLocationTimeFromSP(context);
        instance.totalHaversineDistance =  getTotalHaversineDistanceFromSP(context);
        instance.lastLocationTime =  getLastLocationTimeFromSP(context);

        return instance;
    }

    public static synchronized void saveLatLngToSP(Context context, double latitude, double longitude) {

        Log.e(TAG, "saveLatLngToSP");

        Prefs.with(context).save(SPLabels.LOCATION_LAT, "" + latitude);
        Prefs.with(context).save(SPLabels.LOCATION_LNG, "" + longitude);
    }

    public static synchronized LatLng getSavedLatLngFromSP(Context context) {

        Log.e(TAG, "getSavedLatLngFromSP");

        return new LatLng(Double.parseDouble(Prefs.with(context).getString(SPLabels.LOCATION_LAT, "" + 0)),
                Double.parseDouble(Prefs.with(context).getString(SPLabels.LOCATION_LNG, "" + 0)));
    }

    public static synchronized void saveTotalDistanceToSP(Context context, double totalDistance) {

        Log.e(TAG, "saveTotalDistanceToSP");

        Prefs.with(context).save(SPLabels.TOTAL_DISTANCE, "" + totalDistance);
        DatabaseMM.getInstance(context).updateTotalDistance(totalDistance);
    }

    public static synchronized double getTotalDistanceFromSP(Context context) {

        Log.e(TAG, "getTotalDistanceFromSP");

        double spDistance = Double.parseDouble(Prefs.with(context).getString(SPLabels.TOTAL_DISTANCE, "" + -1));
        double dbDistance = DatabaseMM.getInstance(context).getTotalDistance();
        if (spDistance >= dbDistance) {
            return spDistance;
        } else {
            return dbDistance;
        }
    }

    public static synchronized void saveTotalHaversineDistanceToSP(Context context, double totalHaversineDistance) {

        Log.e(TAG, "saveTotalHaversineDistanceToSP");

        Prefs.with(context).save(SPLabels.TOTAL_HAVERSINE_DISTANCE, "" + totalHaversineDistance);
    }

    public static synchronized double getTotalHaversineDistanceFromSP(Context context) {

        Log.e(TAG, "getTotalHaversineDistanceFromSP");

        return Double.parseDouble(Prefs.with(context).getString(SPLabels.TOTAL_HAVERSINE_DISTANCE, "" + -1));
    }

    public static synchronized void saveLastLocationTimeToSP(Context context, long lastLocationTime) {

        Log.e(TAG, "saveLastLocationTimeToSP");

        Prefs.with(context).save(SPLabels.LOCATION_TIME, "" + lastLocationTime);
    }

    public static synchronized long getLastLocationTimeFromSP(Context context) {

        Log.e(TAG, "getLastLocationTimeFromSP");

        return Long.parseLong(Prefs.with(context).getString(SPLabels.LOCATION_TIME, "" + System.currentTimeMillis()));
    }

    public static synchronized void saveStartTimeToSP(Context context, long startTime) {

        Log.e(TAG, "saveStartTimeToSP");

        Prefs.with(context).save(SPLabels.START_TIME, "" + startTime);
    }

    public static synchronized long getStartTimeFromSP(Context context) {

        Log.e(TAG, "getStartTimeFromSP");

        return Long.parseLong(Prefs.with(context).getString(SPLabels.START_TIME, "0"));
    }

    public static synchronized void saveWaitTimeToSP(Context context, long waitTime) {

        Log.e(TAG, "saveWaitTimeToSP");

        Prefs.with(context).save(SPLabels.WAIT_TIME, "" + waitTime);
    }

    public static synchronized long getWaitTimeFromSP(Context context) {

        Log.e(TAG, "getWaitTimeFromSP");

        return Long.parseLong(Prefs.with(context).getString(SPLabels.WAIT_TIME, "0"));
    }

    public static synchronized void saveTrackingToSP(Context context, int tracking) {

        Log.e(TAG, "saveTrackingToSP");

        Prefs.with(context).save(SPLabels.TRACKING, tracking);
    }

    public static synchronized int getTrackingFromSP(Context context) {

        Log.e(TAG, "getTrackingFromSP");

        try {
            return Prefs.with(context).getInt(SPLabels.TRACKING, 0);
        } catch (Exception e) {
            e.printStackTrace();
            saveTrackingToSP(context, 0);
            return 0;
        }
    }

    public static synchronized boolean isMeteringStateActive(Context context) {

        Log.e(TAG, "isMeteringStateActive");

        int tracking = getTrackingFromSP(context);
        if (1 == tracking) {
            return true;
        } else {
            boolean hasKey = Prefs.with(context).contains(SPLabels.TRACKING);
            if (hasKey) {
                return false;
            } else {
                String meteringState = DatabaseMM.getInstance(context).getMetringState();
                String meteringStateSp = Prefs.with(context).getString(SPLabels.METERING_STATE, DatabaseMM.OFF);
                if (!DatabaseMM.ON.equalsIgnoreCase(meteringState) && !DatabaseMM.ON.equalsIgnoreCase(meteringStateSp)) {
                    return false;
                } else {
                    saveTrackingToSP(context, 1);
                    return true;
                }
            }
        }
    }

    public void start() {

        Log.e(TAG, "start");

        if (!isMeteringStateActive(context)) {

            saveTrackingToSP(context, 1);
            saveStartTimeToSP(context, System.currentTimeMillis());
            saveWaitTimeToSP(context, 0);
            saveTotalDistanceToSP(context, -1);
            saveLastLocationTimeToSP(context, System.currentTimeMillis());
            Prefs.with(context).save(SPLabels.GPS_GSM_DISTANCE_COUNT, 0);
        }

        connectGPSListener(context);
        setupMeteringAlarm(context);

        Log.e("GpsDistanceCalculator", "=totalDistance=" + totalDistance);
    }

    public void resume() {

        Log.e(TAG, "resume");

        if (isMeteringStateActive(context)) {
            connectGPSListener(context);
        }
    }

    public void pause() {

        Log.e(TAG, "pause");

        if (isMeteringStateActive(context)) {
            saveData(context, lastGPSLocation, lastLocationTime);
            disconnectGPSListener();
        }
    }

    public void saveState() {

        Log.e(TAG, "saveState");

        saveData(context, lastGPSLocation, lastLocationTime);
    }

    public void stop() {

        Log.e(TAG, "stop");

        disconnectGPSListener();
        cancelMeteringAlarm(context);

        saveStartTimeToSP(context, System.currentTimeMillis());
        saveWaitTimeToSP(context, 0);
        saveLatLngToSP(context, 0, 0);
        saveTotalDistanceToSP(context, -1);
        saveLastLocationTimeToSP(context, System.currentTimeMillis());
        saveTrackingToSP(context, 0);
        instance.totalDistance = -1;
        instance.totalHaversineDistance = -1;
        instance.lastLocationTime = System.currentTimeMillis();
        instance.lastGPSLocation = null;
        instance.lastFusedLocation = null;

        instance.accumulativeSpeed = 0;
        instance.speedCounter = 0;
        instance.lastWaitWindowTime = System.currentTimeMillis();

//        Log.writePathLogToFile(getEngagementIdFromSP(context) + "m", "totalDistance at stop =" + totalDistance);
        Log.e("stop instance=", "=" + instance);
    }

    public void setupMeteringAlarm(Context context) {

        Log.e(TAG, "setupMeteringAlarm");

        // check task is scheduled or not
        boolean alarmUp = (PendingIntent.getBroadcast(context, METERING_PI_REQUEST_CODE,
                new Intent(context, MeteringAlarmReceiver.class).setAction(CHECK_LOCATION),
                PendingIntent.FLAG_NO_CREATE) != null);
        if (alarmUp) {
            cancelMeteringAlarm(context);
        }

        Intent intent = new Intent(context, MeteringAlarmReceiver.class);
        intent.setAction(CHECK_LOCATION);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, METERING_PI_REQUEST_CODE,
                intent, PendingIntent.FLAG_UPDATE_CURRENT);

        AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        alarmManager.setRepeating(AlarmManager.ELAPSED_REALTIME_WAKEUP, SystemClock.elapsedRealtime() + 20000,
                ALARM_REPEAT_INTERVAL, pendingIntent);
    }

    public void cancelMeteringAlarm(Context context) {

        Log.e(TAG, "cancelMeteringAlarm");

        Intent intent = new Intent(context, MeteringAlarmReceiver.class);
        intent.setAction(CHECK_LOCATION);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, METERING_PI_REQUEST_CODE,
                intent, PendingIntent.FLAG_UPDATE_CURRENT);
        AlarmManager alarmManager = (AlarmManager) context.getSystemService(Activity.ALARM_SERVICE);
        alarmManager.cancel(pendingIntent);
        pendingIntent.cancel();
    }

    private void initializeGPSForegroundLocationFetcher(Context context) {

        Log.e(TAG, "initializeGPSForegroundLocationFetcher");

        if (gpsForegroundLocationFetcher == null) {
            gpsForegroundLocationFetcher = new FusedLocationFetcherBackgroundHigh(context, LOCATION_REFRESH_INTERVAL);
        }

        initializeFusedLocationFetcherBackgroundBalanced(context);

        gsmManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            // TODO: Consider calling
            //    ActivityCompat#requestPermissions
            // here to request the missing permissions, and then overriding
            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
            //                                          int[] grantResults)
            // to handle the case where the user grants the permission. See the documentation
            // for ActivityCompat#requestPermissions for more details.
            return;
        }



//        gsmManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, 1000, 0, GSMListener);
        if (gsmManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {

            gsmManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, LOCATION_REFRESH_INTERVAL, (float) MIN_DISTANCE, GSMListener);

        } else {
            if (gsmManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {

                gsmManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, LOCATION_REFRESH_INTERVAL, (float) MIN_DISTANCE, GSMListener);
            }
        }
        initializeGpsLocationUpdate();
    }

    private void initializeFusedLocationFetcherBackgroundBalanced(Context context) {

        Log.e(TAG, "initializeFusedLocationFetcherBackgroundBalanced");

        if (fusedLocationFetcherBackgroundBalanced == null) {
            fusedLocationFetcherBackgroundBalanced = new FusedLocationFetcherBackgroundBalanced(context, LOCATION_REFRESH_INTERVAL);
        }
    }

    private void initializeGpsLocationUpdate() {

        Log.e(TAG, "initializeFusedLocationUpdate");

        if (gpsLocationUpdate == null) {
            gpsLocationUpdate = new GPSLocationUpdate() {

                @Override
                public void onGPSLocationChanged(Location location) {

                    Log.e(TAG, "GPSLocationUpdate -> onGPSLocationChanged" + location);
                    Log.e(TAG, "Accuracy -> onGPSLocationChanged" + location.getAccuracy());


                    LocationUtils.saveLocation(context, location);
//                    try {
//                        JSONArray jsonArray=new JSONArray();
//                        JSONObject jsonObject=new JSONObject();
//                        JSONArray locationDataArr=new JSONArray();
//                        jsonObject.put("location",locationDataArr.toString());
//                        final ArrayList<CurrentPathItem> validCurrentPathItems = new ArrayList<>();
//                        publishMessage(context,""+jsonArray,validCurrentPathItems);
//                    } catch (JSONException e) {
//                        e.printStackTrace();
//                    }


                    long lastUpdateTime = System.currentTimeMillis();
                    try {
                        if (location.getAccuracy() < MAX_ACCURACY) {
                            if (10 >= (Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0))) {
                                Log.v("gsmgpsdist", String.valueOf(MapUtils.distance(gsmLocation, location)));
                                Log.v("gsmgpscount", String.valueOf(Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0)));

//                                if (MapUtils.distance(gsmLocation, com.example.library.tookan.mylibrary.location) < 50) {
//                                    if ((Utils.compareDouble(com.example.library.tookan.mylibrary.location.getLatitude(), 0.0) != 0) && (Utils.compareDouble(com.example.library.tookan.mylibrary.location.getLongitude(), 0.0) != 0)) {
//                                        drawLocationChanged(com.example.library.tookan.mylibrary.location);
//                                    }
//                                }
                                Prefs.with(context).save(SPLabels.GPS_GSM_DISTANCE_COUNT, Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0) + 1);
                            } else {
//                                if ((Utils.compareDouble(com.example.library.tookan.mylibrary.location.getLatitude(), 0.0) != 0) && (Utils.compareDouble(com.example.library.tookan.mylibrary.location.getLongitude(), 0.0) != 0)) {
//                                    drawLocationChanged(com.example.library.tookan.mylibrary.location);
//                                }

                                Log.v("gsmgpscount2", String.valueOf(Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0)));
                                try {
                                    if (11 == (Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0))) {
                                        Prefs.with(context).save(SPLabels.GPS_GSM_DISTANCE_COUNT, Prefs.with(context).getInt(SPLabels.GPS_GSM_DISTANCE_COUNT, 0) + 1);
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }


                            if(lastGPSLocation!=null)
                            {
                                if (MapUtils.distance(lastGPSLocation, location) > MIN_DISTANCE) {
                                    if ((Utils.compareDouble(location.getLatitude(), 0.0) != 0) && (Utils.compareDouble(location.getLongitude(), 0.0) != 0)) {
                                        drawLocationChanged(location);
                                    }
                                }
                            }
                            else
                            {
                                if ((Utils.compareDouble(location.getLatitude(), 0.0) != 0) && (Utils.compareDouble(location.getLongitude(), 0.0) != 0)) {
                                    drawLocationChanged(location);
                                }
                            }

                        }
                        Log.v("diff", String.valueOf(System.currentTimeMillis() - lastUpdateTime));

                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    logLocationReceive(context,location);
                    logUnfilteredLatLng(context, location);
                }

                @Override
                public void refreshLocationFetchers(final Context context) {
                    reconnectGPSHandler();
                }
            };
        }

        initializeFusedLocationUpdate();
    }

    private void initializeFusedLocationUpdate() {

        Log.e(TAG, "initializeFusedLocationUpdate");

        if (fusedLocationUpdate == null) {
            fusedLocationUpdate = new FusedLocationUpdate() {

                @Override
                public void onFusedLocationChanged(Location location) {
                    lastFusedLocation = location;
                }
            };
        }
    }

    private void connectGPSListener(Context context) {

        Log.e(TAG, "connectGPSListener");

        disconnectGPSListener();
        try {
            initializeGPSForegroundLocationFetcher(context);
            gpsForegroundLocationFetcher.connect();
            fusedLocationFetcherBackgroundBalanced.connect();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disconnectGPSListener() {

        Log.e(TAG, "disconnectGPSListener");

        try {
            if (gpsForegroundLocationFetcher != null) {
                gpsForegroundLocationFetcher.destroy();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (fusedLocationFetcherBackgroundBalanced != null) {
                fusedLocationFetcherBackgroundBalanced.destroy();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void drawLocationChanged(Location location) {

        Log.e(TAG, "drawLocationChanged");

        try {
            final LatLng currentLatLng = new LatLng(location.getLatitude(), location.getLongitude());


            if (Utils.compareDouble(totalDistance, -1.0) == 0) {
                totalDistance = 0;
                totalHaversineDistance = 0;
                lastGPSLocation = null;
                lastLocationTime = System.currentTimeMillis();
            }

            LatLng lastLatLng = null;

            if (lastGPSLocation != null) {
                lastLatLng = new LatLng(lastGPSLocation.getLatitude(), lastGPSLocation.getLongitude());
            } else {
                lastLatLng = getSavedLatLngFromSP(context);
            }
            double displacement = MapUtils.distance(lastLatLng, currentLatLng);
            if ((Utils.compareDouble(lastLatLng.latitude, 0.0) != 0) && (Utils.compareDouble(lastLatLng.longitude, 0.0) != 0)) {
                totalHaversineDistance = totalHaversineDistance + displacement;
                saveTotalHaversineDistanceToSP(context, totalHaversineDistance);
            }
             Double speedMPS=getSpeed(lastLatLng,currentLatLng);
            if (speedMPS <= MAX_SPEED_THRESHOLD) {
                if ((Utils.compareDouble(lastLatLng.latitude, 0.0) != 0) && (Utils.compareDouble(lastLatLng.longitude, 0.0) != 0)) {
                    calculateWaitTime(speedMPS);
                    addLatLngPathToDistance(lastLatLng, currentLatLng, location, speedMPS);
                    if (lastGPSLocation == null) {
                    }
                } else {
                    lastLocationTime = System.currentTimeMillis();
                    saveData(context, lastGPSLocation, lastLocationTime);
                }

                lastGPSLocation = location;
            } else {
                reconnectGPSHandler();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void calculateWaitTime(double speedMPS) {

        Log.e(TAG, "calculateWaitTime");

        long millisTillWaitWindow = System.currentTimeMillis() - lastWaitWindowTime;

        if (millisTillWaitWindow < 20000) {

            accumulativeSpeed = accumulativeSpeed + speedMPS;
            speedCounter++;
        } else {

            double speedAvg = accumulativeSpeed / speedCounter;
            if (speedAvg < 1.4) {
                long waitTime = getWaitTimeFromSP(context) + 20000l;
                saveWaitTimeToSP(context, waitTime);
            }
            this.accumulativeSpeed = 0;
            this.speedCounter = 0;
            this.lastWaitWindowTime = System.currentTimeMillis();
        }

        Log.e("window time", "=" + lastWaitWindowTime);
        Log.e("accumulativeSpeed time", "=" + accumulativeSpeed);
        Log.e("speedCounter time", "=" + speedCounter);
    }

    public void reconnectGPSHandler() {

        Log.e(TAG, "reconnectGPSHandler");

        disconnectGPSListener();
        new Handler().postDelayed(new Runnable() {

            @Override
            public void run() {
                connectGPSListener(context);
            }
        }, 5000);
    }

    private synchronized void addLatLngPathToDistance(final LatLng lastLatLng, final LatLng currentLatLng,
                                                      final Location currentLocation, double speedMPS) {

        Log.e(TAG, "addLatLngPathToDistance");

        try {
            final double displacement = MapUtils.distance(lastLatLng, currentLatLng);

            // Avoid Adding locations which have smaller displacements
//            if (displacement < (LOCATION_REFRESH_INTERVAL * 4) / 1000) return;

            boolean isMock = LocationUtils.isMockLocationsEnabled(context);
            boolean isInternet = Utils.isDeviceOnline(context);
            boolean isGpsEnabled = LocationUtils.isGPSEnabled(context);
            int batteryLevel = Utils.getBatteryLevel(context);

            if (Utils.compareDouble(displacement, MAX_DISPLACEMENT_THRESHOLD) == -1) {
                boolean validDistance = updateTotalDistance(lastLatLng, currentLatLng, displacement, currentLocation);
                if (validDistance) {

                    DatabaseMM.getInstance(context).insertCurrentPathItem(-1, lastLatLng.latitude, lastLatLng.longitude,
                            currentLatLng.latitude, currentLatLng.longitude, displacement, 0, 0,
                            System.currentTimeMillis(), isMock ? 1 : 0,
                            (lastGPSLocation != null && lastGPSLocation.hasAccuracy() ? lastGPSLocation.getAccuracy() : -1),
                            isGpsEnabled ? 1 : 0,
                            speedMPS,
                            (lastGPSLocation != null && lastGPSLocation.hasAltitude() ? lastGPSLocation.getAltitude() : -1),
                            isInternet ? 1 : 0, batteryLevel);
                    retrievePaths(context,false,null);
                    logLocationInsert(context);
                    logFilteredLatLng(context, lastLatLng.latitude,lastLatLng.longitude);


                }
            } else {

                final long rowId = DatabaseMM.getInstance(context).insertCurrentPathItem(-1, lastLatLng.latitude, lastLatLng.longitude,
                        currentLatLng.latitude, currentLatLng.longitude, displacement, 1, 1,
                        System.currentTimeMillis(), isMock ? 1 : 0,
                        (lastGPSLocation.hasAccuracy() ? lastGPSLocation.getAccuracy() : -1),
                        isGpsEnabled ? 1 : 0,
                        speedMPS,
                        (lastGPSLocation.hasAltitude() ? lastGPSLocation.getAltitude() : -1),
                        isInternet ? 1 : 0, batteryLevel);

                callGoogleDirectionsAPI(lastLatLng, currentLatLng, displacement, currentLocation, rowId);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private synchronized boolean updateTotalDistance(LatLng lastLatLng, LatLng currentLatLng, double deltaDistance, Location currentLocation) {

        Log.e(TAG, "updateTotalDistance");

        boolean validDistance = false;
        if (deltaDistance > 0.0 && deltaDistance < 20001) {
            LatLngPair latLngPair = new LatLngPair(lastLatLng, currentLatLng, deltaDistance);
            if (deltaLatLngPairs == null) {
                deltaLatLngPairs = new ArrayList<LatLngPair>();
            }

            if (!deltaLatLngPairs.contains(latLngPair) && totalDistance < 200001) {
                totalDistance = totalDistance + deltaDistance;
                deltaLatLngPairs.add(latLngPair);
                validDistance = true;

                lastLocationTime = System.currentTimeMillis();

                saveData(context, lastGPSLocation, lastLocationTime);

                // Save the Valid Location to the Shared Preferences
//                AppLocation appLocation = new AppLocation(currentLocation);
//                appLocation.setIsMock(LocationUtils.isMockLocationsEnabled(context));
//                appLocation.setIsHighAccuracy(LocationUtils.isGPSEnabled(context));
//                appLocation.setIsInternetAvailable(NetworkUtils.isDeviceOnline(context));
//                appLocation.setBatteryLevel(com.tookan.utility.Utils.getBatteryLevel(context));
//                appLocation.saveToSharedPreferences(context);
            }
        }
        return validDistance;
    }

    private synchronized void callGoogleDirectionsAPI(LatLng lastLatLng, LatLng currentLatLng, double displacement, Location currentLocation, long rowId) {

        Log.e(TAG, "callGoogleDirectionsAPI");

        if (directionsAsyncTasks == null) {
            directionsAsyncTasks = new ArrayList<>();
        }
        DirectionsAsyncTask directionsAsyncTask = new DirectionsAsyncTask(lastLatLng, currentLatLng, displacement, currentLocation, rowId);
        if (!directionsAsyncTasks.contains(directionsAsyncTask)) {
            directionsAsyncTasks.add(directionsAsyncTask);
            directionsAsyncTask.execute();
        }
    }

    private synchronized void updateGAPIDistance(String result, double displacementToCompare, LatLng source, LatLng destination, Location currentLocation, long rowId) {

        Log.e(TAG, "updateGAPIDistance");

        try {
            double distanceOfPath = Double.MAX_VALUE;
            JSONObject jsonObject = new JSONObject(result);
            String status = jsonObject.getString("status");
            if ("OK".equalsIgnoreCase(status)) {
                JSONObject leg0 = jsonObject.getJSONArray("routes").getJSONObject(0).getJSONArray("legs").getJSONObject(0);
                distanceOfPath = leg0.getJSONObject("distance").getDouble("value");
            }
            Log.e(TAG, "distanceOfPath:"+distanceOfPath);
            Log.e(TAG, "displacementToCompare:"+displacementToCompare);
            Log.e(TAG, "comaprisoin:"+Utils.compareDouble(distanceOfPath, (displacementToCompare * 1.5)));
            if (Utils.compareDouble(distanceOfPath, (displacementToCompare * 1.5)) <= 0) {                                                        // distance would be approximately correct
                boolean validDistance = updateTotalDistance(source, destination, distanceOfPath, currentLocation);
                if (validDistance) {

                    JSONArray routeArray = jsonObject.getJSONArray("routes");
                    JSONObject routes = routeArray.getJSONObject(0);
                    JSONObject overviewPolylines = routes.getJSONObject("overview_polyline");
                    String encodedString = overviewPolylines.getString("points");
                    List<LatLng> list = MapUtils.decodeDirectionsPolyline(encodedString);

                    PolylineOptions polylineOptions = new PolylineOptions();

                    for (int z = 0; z < list.size() - 1; z++) {
                        LatLng src = list.get(z);
                        LatLng dest = list.get(z + 1);
                        polylineOptions.add(new LatLng(src.latitude, src.longitude), new LatLng(dest.latitude, dest.longitude));

                        boolean isMock = LocationUtils.isMockLocationsEnabled(context);
                        boolean isInternet = Utils.isDeviceOnline(context);
                        boolean isGpsEnabled = LocationUtils.isGPSEnabled(context);
                        int batteryLevel = Utils.getBatteryLevel(context);

                        DatabaseMM.getInstance(context).insertCurrentPathItem(rowId, src.latitude, src.longitude,
                                dest.latitude, dest.longitude, MapUtils.distance(src, dest), 0, 0,
                                System.currentTimeMillis(), isMock ? 1 : 0, 10,
                                isGpsEnabled ? 1 : 0, 14, (10), isInternet ? 1 : 0, batteryLevel);
                        logFilteredLatLng(context, src.latitude, src.longitude);
                    }
                    DatabaseMM.getInstance(context).updateCurrentPathItemSectionIncomplete(rowId, 0);
                    retrievePaths(context, false, null);
                    logLocationInsert(context);

                }
            } else {
                throw new Exception();
            }
        } catch (Exception e) {
            e.printStackTrace();    // displacement would be correct
            boolean validDistance = updateTotalDistance(source, destination, displacementToCompare, currentLocation);
            if (validDistance) {
                DatabaseMM.getInstance(context).updateCurrentPathItemSectionIncompleteAndGooglePath(rowId, 0, 0);
               retrievePaths(context, false, null);
            }
        }
    }

    public void saveData(Context context, Location location, long lastLocationTime) {

        Log.e(TAG, "saveData");

        if (location != null) {
            saveLatLngToSP(context, location.getLatitude(), location.getLongitude());

            double savedTotalDist = getTotalDistanceFromSP(context);
            if (totalDistance < savedTotalDist) {
                totalDistance = savedTotalDist;
            } else {
                saveTotalDistanceToSP(context, totalDistance);
            }

            saveLastLocationTimeToSP(context, lastLocationTime);
        }
    }

    private class DirectionsAsyncTask extends AsyncTask<Void, Void, String> {

        String url;
        double displacementToCompare;
        LatLng source, destination;
        Location currentLocation;
        long rowId;

        public DirectionsAsyncTask(LatLng source, LatLng destination, double displacementToCompare,
                                   Location currentLocation, long rowId) {

            Log.e(TAG, "DirectionsAsycTask");

            this.source = source;
            this.destination = destination;
            this.url = MapUtils.makeDirectionsURL(source, destination);
            this.displacementToCompare = displacementToCompare;
            this.currentLocation = currentLocation;
            this.rowId = rowId;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Void... params) {

            return new HttpRequester().getJSONFromUrl(url);
        }

        @Override
        protected void onPostExecute(String result) {
            super.onPostExecute(result);

            if (result != null) {
                Log.e(TAG, "Directions url:"+url);
                Log.e(TAG, "Directions url:"+url);
                updateGAPIDistance(result, displacementToCompare, source, destination, currentLocation, rowId);
            }
            else
            {
                retrievePaths(context,false,null);
            }

            directionsAsyncTasks.remove(this);
        }


        @Override
        public boolean equals(Object o) {
            try {
                DirectionsAsyncTask matchO = (DirectionsAsyncTask) o;
                if (((Utils.compareDouble(matchO.source.latitude, this.source.latitude) == 0)
                        && (Utils.compareDouble(matchO.source.longitude, this.source.longitude) == 0)) ||
                        ((Utils.compareDouble(matchO.destination.latitude, this.destination.latitude) == 0)
                                && (Utils.compareDouble(matchO.destination.longitude, this.destination.longitude) == 0))) {
                    return true;
                } else {
                    return false;
                }
            } catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }


    private void logLocationReceive(Context context, Location location) {

//        if (Config.isRelease()) return;
//
//        long yourmilliseconds = System.currentTimeMillis();
//        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
//        Date resultdate = new Date(yourmilliseconds);
//        final LatLng currentLatLng = new LatLng(location.getLatitude(), location.getLongitude());
//        LatLng lastLatLng;
//        if (lastGPSLocation != null) {
//            lastLatLng = new LatLng(lastGPSLocation.getLatitude(), lastGPSLocation.getLongitude());
//        } else {
//            lastLatLng = getSavedLatLngFromSP(context);
//        }
//        String log = "Location receive at:"+sdf.format(resultdate) +" with Accuracy:"+location.getAccuracy()+ " Speed: "+getSpeed(lastLatLng,currentLatLng)+"mps Distance: "+MapUtils.distance(lastGPSLocation, location)+"\n";
//
////        Log.writeLogToFile("log_battery", log);
//
//        FileData fileData = new FileData();
//        fileData.content = log;
//        fileData.name = "log_location_recieve";
//        fileData.type = com.tookan.appdata.TookanLocationMode.FileType.LOG_FILE;
//
//        new FileWriterTask().execute(fileData);
//
////        Log.writeLogToInternalDir("log_battery", log);
    }


    private void logLocationInsert(Context context) {

//        if (Config.isRelease()) return;
//
//        long yourmilliseconds = System.currentTimeMillis();
//        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
//        Date resultdate = new Date(yourmilliseconds);
//        String log = "Location insert at:"+sdf.format(resultdate) + "\n";
//
////        Log.writeLogToFile("log_battery", log);
//
//        FileData fileData = new FileData();
//        fileData.content = log;
//        fileData.name = "log_location_insert";
//        fileData.type = com.tookan.appdata.TookanLocationMode.FileType.LOG_FILE;
//
//        new FileWriterTask().execute(fileData);
//
////        Log.writeLogToInternalDir("log_battery", log);
    }

    public double getSpeed(LatLng lastLatLng, LatLng currentLatLng)
    {
        long newLocationTime = System.currentTimeMillis();
        long millisDiff = newLocationTime - lastLocationTime;
        long secondsDiff = millisDiff / 1000;

        double displacement = MapUtils.distance(lastLatLng, currentLatLng);

        double speedMPS = 0;
        if (secondsDiff > 0) {
            speedMPS = displacement / secondsDiff;
        }
        return speedMPS;
    }


    private void logUnfilteredLatLng(Context context,Location location) {

//        if (Config.isRelease()) return;
//
//        String log = location.getLatitude()+","+location.getLongitude()+"\n";
//
////        Log.writeLogToFile("log_battery", log);
//
//        FileData fileData = new FileData();
//        fileData.content = log;
//        fileData.name = "log_unfiltered_latlng";
//        fileData.type = com.tookan.appdata.TookanLocationMode.FileType.LOG_FILE;
//
//        new FileWriterTask().execute(fileData);
//
////        Log.writeLogToInternalDir("log_battery", log);
    }


    private void logFilteredLatLng(Context context,double latitude,double longitude) {

//        if (Config.isRelease()) return;
//
//        String log = latitude+","+longitude+"\n";
//
////        Log.writeLogToFile("log_battery", log);
//
//        FileData fileData = new FileData();
//        fileData.content = log;
//        fileData.name = "log_filtered_latlng";
//        fileData.type = com.tookan.appdata.TookanLocationMode.FileType.LOG_FILE;
//
//        new FileWriterTask().execute(fileData);

//        Log.writeLogToInternalDir("log_battery", log);
    }


    public  void retrievePaths(final Context context, final boolean isPositive, final String reason) {

        try {

            Log.e(TAG, "is hit in progress" + (!Utils.isDeviceOnline(context) || Prefs.with(context).getBoolean(Keys.AppLocation.HIT_IN_PROGRESS, false)));
            if(Prefs.with(context).getBoolean(Keys.AppLocation.HIT_IN_PROGRESS, false))
            {
                long lastTimeStamp =getLastLocationUpdated(context);
                if (System.currentTimeMillis() - lastTimeStamp > 80000) {
                    Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, false);
                }
            }
            if(!Utils.isDeviceOnline(context) || Prefs.with(context).getBoolean(Keys.AppLocation.HIT_IN_PROGRESS, false))
            {

                return;
            }
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {

                        final ArrayList<CurrentPathItem> validCurrentPathItems = new ArrayList<>();
                        validCurrentPathItems.addAll(DatabaseMM.getInstance(context).getCurrentPathItemsToUpload());
                        JSONArray locationDataArr = new JSONArray();
                        Log.e(TAG, "Locations" + validCurrentPathItems.size());
                        if (validCurrentPathItems.size() > 0) {
                            Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, true);
                            LatLng pathSource = null;
                            for (int i = 0; i < validCurrentPathItems.size(); i++) {
                                CurrentPathItem currentPathItem = validCurrentPathItems.get(i);
                                LatLng nextSourceLatLng = null;
                                if (1 == currentPathItem.googlePath) {
                                } else {
                                    try {
                                        if (pathSource == null) {
                                            pathSource = currentPathItem.sLatLng;
                                            nextSourceLatLng = currentPathItem.sLatLng;
                                        }

                                        if (i < validCurrentPathItems.size() - 1) {
                                            if (MapUtils.distance(currentPathItem.dLatLng, validCurrentPathItems.get(i + 1).sLatLng) < 2) {
                                                if (MapUtils.distance(pathSource, currentPathItem.dLatLng) < 0) {
                                                    //don't add

                                                } else {
                                                    //add pathSource, currentPathItem.dLatLng
                                                    nextSourceLatLng = currentPathItem.dLatLng;

                                                }
                                            } else {
                                                //add pathSource, currentPathItem.dLatLng
                                                nextSourceLatLng = validCurrentPathItems.get(i + 1).sLatLng;

                                            }
                                        } else {
                                            //add pathSource, currentPathItem.dLatLng
                                            nextSourceLatLng = currentPathItem.dLatLng;
                                        }


                                        JSONObject locationData = new JSONObject();
                                        locationData.put("lat", currentPathItem.sLatLng.latitude);
                                        locationData.put("lng", currentPathItem.sLatLng.longitude);
                                        locationData.put("tm_stmp", currentPathItem.colTimestamp);
                                        locationData.put("acc", currentPathItem.colAccuracy);
                                        locationData.put("alt", currentPathItem.colAltitude);
                                        locationData.put("spd", currentPathItem.colSpeed);
                                        locationData.put("mock", currentPathItem.colIsMock);
                                        locationData.put("gps", currentPathItem.colIsHighAccuracy);
                                        locationData.put("net", currentPathItem.colInternetAvailable);
                                        locationData.put("bat_lvl", currentPathItem.colBatteryLevels);
                                        locationData.put("d_acc", 1);

                                        locationDataArr.put(locationData);
                                        pathSource = nextSourceLatLng;

                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }

                            Log.e(TAG, "Locations" + locationDataArr);
                            setLastLocationUpdated(context, System.currentTimeMillis());
                            JSONArray jsonArray=new JSONArray();
                            JSONObject jsonObject=new JSONObject();
                            jsonObject.put("location",locationDataArr.toString());
//                            jsonObject.put("lat", validCurrentPathItems.get(validCurrentPathItems.size()-1).sLatLng.latitude);
//                            jsonObject.put("lng", validCurrentPathItems.get(validCurrentPathItems.size()-1).sLatLng.latitude);
                            jsonArray.put(jsonObject);
                            publishMessage(context,""+jsonArray,validCurrentPathItems);

                            Log.i("publish message",""+jsonArray);

                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            }).start();

        } catch (Exception e) {

            e.printStackTrace();
        }

    }

    /**
     * Method to save the Last Location Updated TimeStamp
     *
     * @param context
     * @param timeStamp
     */
    public static void setLastLocationUpdated(Context context, long timeStamp) {
        Prefs.with(context).save(Keys.Prefs.LAST_LOCATION_UPDATE_TIMESTAMP, timeStamp);
    }


    /**
     * Method to save the Last Location Updated TimeStamp
     *
     * @param context
     */
    public static long getLastLocationUpdated(Context context) {
        return Prefs.with(context).getLong(Keys.Prefs.LAST_LOCATION_UPDATE_TIMESTAMP, 0);
    }


    public  void publishMessage(Context context, String publishMessage, ArrayList<CurrentPathItem> validCurrentPathItems){
        if(mqttAndroidClient==null || !mqttAndroidClient.isConnected()){

            establishMQTTConnection(context, publishMessage,  validCurrentPathItems);
            return;
        }

        try {
//            logMqttHistory("Message Published:"+publishMessage);
            MqttMessage message = new MqttMessage();
            message.setPayload(publishMessage.getBytes());
            message.setQos(2);
            mqttAndroidClient.publish(TookanLocationTracking.getKey(context), message);

        } catch (MqttException e) {
            Log.i("Error Publishing: " ,"=="+e.getMessage());
//            logMqttHistory("Error Publishing:"+e.getMessage());
            e.printStackTrace();
        }
        clearDatabase(context,validCurrentPathItems);
    }

    private static void clearDatabase(Context context, ArrayList<CurrentPathItem> validCurrentPathItems) {
        {

            try {
                ArrayList<Long> rowIds = new ArrayList<>();
                for (CurrentPathItem currentPathItem : validCurrentPathItems) {
                    rowIds.add(currentPathItem.id);
                }

                DatabaseMM.getInstance(context).updateCurrentPathItemAcknowledgedForArray(rowIds, 1);
//                                                    changeTaskStatus(context, isPositive, reason, false);

            } catch (Exception e) {
                e.printStackTrace();
//                                                changeTaskStatus(context, isPositive, reason, false);
            }
        }
    }

    public  void establishMQTTConnection(final Context context, final String publishMessage, final ArrayList<CurrentPathItem> validCurrentPathItems)
    {
        String clientId = MqttClient.generateClientId();
        //test.mosquitto.org
//        tracking.tookan.io
        mqttAndroidClient = new MqttAndroidClient(context, "tcp://tracking.tookan.io", clientId);
        mqttAndroidClient.setCallback(new MqttCallbackExtended() {
            @Override
            public void connectComplete(boolean reconnect, String serverURI) {

                if (reconnect) {


                } else {

                }
            }

            @Override
            public void connectionLost(Throwable cause) {
                Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, false);
            }

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Log.i("message",""+message);
                Log.i("topic",""+topic);

            }

            @Override
            public void deliveryComplete(IMqttDeliveryToken token) {
                Log.d(TAG, " MQTT deliveryComplete");
                Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, false);
            }
        });
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setCleanSession(false);
        char[] charArray ={'t'};
//        mqttConnectOptions.setPassword(charArray);
//        mqttConnectOptions.setUserName("t");

//        mqttConnectOptions.setMqttVersion(MqttConnectOptions.MQTT_VERSION_3_1);

        try {
            //addToHistory("Connecting to " + serverUri);
            mqttAndroidClient.connect(mqttConnectOptions, null, new IMqttActionListener() {
                @Override
                public void onSuccess(IMqttToken asyncActionToken) {
                    Log.d(TAG, " MQTT onSuccess");
//                    logMqttHistory("connection success ");

                    publishMessage(context, publishMessage, validCurrentPathItems);

//                    DisconnectedBufferOptions disconnectedBufferOptions = new DisconnectedBufferOptions();
//                    disconnectedBufferOptions.setBufferEnabled(true);
//                    disconnectedBufferOptions.setBufferSize(100);
//                    disconnectedBufferOptions.setPersistBuffer(false);
//                    disconnectedBufferOptions.setDeleteOldestMessages(false);
//                    mqttAndroidClient.setBufferOpts(disconnectedBufferOptions);

                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    Log.d(TAG, "MQTT exception"+exception);
                    Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, false);
                }
            });


        } catch (MqttException ex){
            ex.printStackTrace();
        }

    }




}
