package tookan.tookanlocationtrackinglibrary.retrofit2;

/**
 * Class to store REQUEST_CODE(s) for various transition events
 *
 * @author Rishabh
 */
public interface Codes
{

    /**
     * Status Codes of the Response sent by the
     * Server. These status codes will be used
     * for segregation of the Actions to be
     * performed after getting .
     */
    enum StatusCode {

        // No Error
        NONE(0),

        // Server Errors
        ACTION_COMPLETE(200),
        SHOW_ERROR_MESSAGE(201),
        INVALID_ACCESS_TOKEN(101),
        PICK_UP_INCOMPLETE(410),
        BILLING_PLAN_EXPIRED(401),
        PARAMETER_MISSING(100),
        TASK_DELETED(501),
        AVAIBALITY_STATUS_CHANGED(210),

        // Retrofit Errors
        REQUEST_ERROR(400),
        EXECUTION_ERROR(404),
        NETWORK_ERROR(411),
        PARSING_ERROR(413);

        private final int statusCode;

        /**
         * Constructor
         *
         * @param statusCode
         */
        StatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        /**
         * @param statusCode
         * @return
         */
        public static StatusCode get(int statusCode) {

            StatusCode status = NONE;

            for (StatusCode value : values()) {
                if (value.getStatusCode() == statusCode) {
                    status = value;
                    break;
                }
            }

            return status;
        }

        public int getStatusCode() {
            return statusCode;
        }
    }


    /**
     * Stores all the Codes that differentiate the Permissions
     */
    interface Permission {

        int LOCATION = 1;
        int CAMERA = 2;
        int READ_FILE = 3;
        int OPEN_GALLERY = 4;
        int SAVE_BITMAP = 5;
        int READ_PHONE_STATE = 6;
    }

    /**
     * Image Selection codes are used for segregating
     * the events according to the resources.
     * <p/>
     * In series of 300
     */
    interface ImageSelection {

        int CAPTURE_FROM_CAMERA = 301;
        int PICK_FROM_GALLERY = 302;
    }

    /**
     * Request codes are used for segregating the various
     * requests used to perform actions and getting the
     * results back through that request code.
     * <p/>
     * In series of 500
     */
    interface Request {

        int PLAY_SERVICES_ERROR = 501;
        int LOCATION_ACCESS_REQUEST = 502;
        int OPEN_DEVELOPER_SETTINGS = 503;

        int OPEN_CAMERA_ACTIVITY = 505;

        int OPEN_CHANGE_PASSWORD_SCREEN = 506;
        int OPEN_TASK_ACTIVITY = 507;
        int OPEN_SETTINGS_ACTIVITY = 508;
        int OPEN_TUTORIALS_ACTIVITY = 509;
        int OPEN_NOTIFICATION_TONES_ACTIVITY = 510;

        int RESTART_LOCATION_SERVICE = 511;

        // Used by CustomFieldImages
        int OPEN_CAMERA_CUSTOM_FIELD_IMAGE = 512;
        int OPEN_GALLERY_CUSTOM_FIELD_IMAGE = 513;

        // Used by AddImagesFragment
        int OPEN_CAMERA_ADD_IMAGE = 514;
        int OPEN_GALLERY_ADD_IMAGE = 515;
        int OPEN_SCAN_CARD_SCREEN = 516;
        int OPEN_CHECKLIST_ACTIVITY = 517;
        int OPEN_FILTER_ACTIVITY = 518;
        int OPEN_ADD_TASK_ACTIVITY = 519;
        int OPEN_GET_ADDRESS_ACTIVITY = 520;
        int OPEN_SUBTASK_ACTIVITY = 521;
        int OPEN_NAVIGATION_ACTIVITY = 522;

        //Barcodes
        int OPEN_SCANNER_ADD_BARCODE = 523;
        int OPEN_SCANNER_EDIT_BARCODE = 524;
        int OPEN_SCANNER_CUSTOMFIELD_BARCODE = 525;
        int OPEN_VEHICLE_INFO_ACTIVITY = 526;
        int ACTION_MANAGE_OVERLAY_PERMISSION_REQUEST_CODE=527;
        int OPEN_EDIT_AVAILABILITY_ACTIVITY = 528;
        int OPEN_SAVE_AND_REVIEW_BOTH_ACTIVITY = 529;
        int OPEN_SAVE_AND_REVIEW_ACTIVITY = 530;
        int PLACE_AUTOCOMPLETE_REQUEST_CODE = 531;
        int OPEN_TASK_DETAIL_ACTIVITY = 532;
    }

    /**
     * Purpose Codes to init the Message Dialogs and perform
     * the actions accordingly
     * <p/>
     * In series of 600
     */
    interface Purpose {

        int CHECK_INTERNET = 601;
        int DISABLE_MOCK_LOCATIONS = 602;

        int ASK_UPDATE = 603;
        int FORCE_UPDATE = 604;

        int CHECK_PASSWORD = 605;
        int ASK_USER_CHECK_EMAIL = 606;

        int PROFILE_FIELDS_EMPTY = 607;
        int PROFILE_CONTACT_INVALID = 608;
        int ASK_USER_DISCARD_CHANGES = 609;
        int NOTE_EXISTS = 610;
    }

    /**
     * Notifications Codes are used to segregate the Notification
     * messages and perform actions accordingly.
     * <p/>
     * In series of 700
     */
    interface Notification {

        int TASK_ASSIGNED = 701;
        int TASK_RESCHEDULED = 702;
        int TASK_DELETED = 703;
    }

    /**
     * Class to accumulate all the errors on a single place
     * <p/>
     * In series of 800
     */
    interface Error {

        int NO_FLEET_INFO = 801;
        int JSON_PARSING = 802;
        int NO_ACCESS_TOKEN = 803;
        int PRE_REQUISITES_ERR = 804;
        int RE_LOGIN = 805;
    }

}
