package tookan.tookanlocationtrackinglibrary.metering;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import tookan.tookanlocationtrackinglibrary.metering.datastructure.GpsState;
import tookan.tookanlocationtrackinglibrary.metering.datastructure.SPLabels;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;


public class MeteringAlarmReceiver extends BroadcastReceiver {

    private static final String CHECK_LOCATION = "com.mapmeter.CHECK_LOCATION";

    private static final long MINUTE = 60 * 1000;
    private static final long HALF_MINUTE = 30 * 1000;
    private static final long MAX_TIME_BEFORE_LOCATION_UPDATE = 2 * MINUTE;


    @Override
    public void onReceive(final Context context, Intent intent) {
        try {
            String action = intent.getAction();
            if (CHECK_LOCATION.equals(action)) {
                long timeDiff = System.currentTimeMillis() - GpsDistanceCalculator.lastLocationTime;



                if (timeDiff >= 6 * MINUTE) {
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.GREATER_SIX.getOrdinal());
//                    Intent dialogIntent = new Intent(context, activity.getClass());
//                    dialogIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                    dialogIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
//                    dialogIntent.putExtra(TookanLocationMode.DIALOG_MESSAGE, "Please Restart Your Phone");
//                    context.startActivity(dialogIntent);
                    GpsDistanceCalculator.lastLocationTime = System.currentTimeMillis();
                    GpsDistanceCalculator.saveLastLocationTimeToSP(context, GpsDistanceCalculator.lastLocationTime);
//                    if (LocationUtils.isGPSEnabled(context)) {
//                        Utils.longToast(activity, activity.getString(R.string.app_restart_message));
//                    }

                } else if (timeDiff > 7 * HALF_MINUTE) {
                    if (Prefs.with(context).getInt(SPLabels.GPS_STATE, GpsState.ZERO_TWO.getOrdinal())
                            == GpsState.TWO_LESS_FOUR.getOrdinal()) {

//                        Intent i = new Intent(context, activity.getClass());
//                        i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                        i.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
//                        i.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
//                        context.startActivity(i);
                    } else {
                        GpsDistanceCalculator.gpsLocationUpdate.refreshLocationFetchers(context);
                    }
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.GREATER_FOUR.getOrdinal());
                } else if (timeDiff > MAX_TIME_BEFORE_LOCATION_UPDATE) {
                    GpsDistanceCalculator.gpsLocationUpdate.refreshLocationFetchers(context);
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.TWO_LESS_FOUR.getOrdinal());
                } else {
                    Prefs.with(context).save(SPLabels.GPS_STATE, GpsState.ZERO_TWO.getOrdinal());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}