package tookan.tookanlocationtrackinglibrary.location;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.maps.model.LatLng;

import tookan.tookanlocationtrackinglibrary.metering.Keys;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;



public class LocationUtils {

    public static double LATITUDE = 0;
    public static double LONGITUDE = 0;
    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 1972;


    /**
     * Method to initialize the Location
     */
    public static void init(Context context) {

        try {

            long latitude = Prefs.with(context).getLong(Keys.Prefs.LATITUDE, 0);
            long longitude = Prefs.with(context).getLong(Keys.Prefs.LONGITUDE, 0);

            LATITUDE = Double.longBitsToDouble(latitude);
            LONGITUDE = Double.longBitsToDouble(longitude);

        } catch (Exception ex) {

            Prefs.with(context).remove(Keys.Prefs.LATITUDE);
            Prefs.with(context).remove(Keys.Prefs.LONGITUDE);

            init(context);
        }
    }

    /**
     * Method to save the com.example.library.tookan.mylibrary.location in preferences
     *
     * @param location
     */
    public static void saveLocation(Context context, Location location) {

        if (location == null)
            return;

        LATITUDE = location.getLatitude();
        LONGITUDE = location.getLongitude();

        Prefs.with(context).save(Keys.Prefs.LATITUDE, Double.doubleToRawLongBits(LATITUDE));
        Prefs.with(context).save(Keys.Prefs.LONGITUDE, Double.doubleToRawLongBits(LONGITUDE));
    }

    /**
     * Method to check whether the mock locations are enabled
     *
     * @return
     */
    public static boolean isMockLocationsEnabled(Context context) {

        return Build.VERSION.SDK_INT < Build.VERSION_CODES.M &&
                !(Settings.Secure.getString(context.getContentResolver(),
                        Settings.Secure.ALLOW_MOCK_LOCATION).equals("0"));
    }

    /**
     * Method to check whether com.example.library.tookan.mylibrary.location services
     * through network are enabled or not
     *
     * @return
     */
    private static boolean isProviderEnabled(Context context, String provider) {

        LocationManager manager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);

        try {
            return manager.isProviderEnabled(provider);
        } catch (Exception ex) {
            return false;
        }
    }

    /**
     * Method to check whether the GPS is enabled or not
     *
     * @param context
     * @return
     */
    public static boolean isGPSEnabled(Context context) {

        return isProviderEnabled(context, LocationManager.GPS_PROVIDER);
    }

    /**
     * Method to check whether com.example.library.tookan.mylibrary.location services via Network are enabled or not
     *
     * @return
     */
    public static boolean isNetworkEnabled(Context context) {

        return isProviderEnabled(context, LocationManager.NETWORK_PROVIDER);
    }

    /**
     * Method to save the com.example.library.tookan.mylibrary.location in preferences
     */
    public static Location getLastLocation(Context context) {

        long lat = Prefs.with(context).getLong(Keys.Prefs.LATITUDE, 0);
        long lng = Prefs.with(context).getLong(Keys.Prefs.LONGITUDE, 0);

        double latitude = Double.longBitsToDouble(lat);
        double longitude = Double.longBitsToDouble(lng);

        Location lastLocation = new Location("LAST_LOCATION");

        lastLocation.setLatitude(latitude);
        lastLocation.setLongitude(longitude);

        return lastLocation;
    }

    /**
     * Method to build com.example.library.tookan.mylibrary.location from latitude and Longitude
     *
     * @param latitude
     * @param longitude
     * @return
     */
    public static Location toLocation(double latitude, double longitude) {

        Location location = new Location("Location");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        return location;
    }

    /**
     * Method to build com.example.library.tookan.mylibrary.location from latitude and Longitude
     *
     * @param locationLatLng
     * @return
     */
    public static Location toLocation(LatLng locationLatLng) {

        if (locationLatLng == null)
            return null;

        return toLocation(locationLatLng.latitude, locationLatLng.longitude);
    }

    public static boolean isPlayServicesAvailable(Activity activity) {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int result = googleAPI.isGooglePlayServicesAvailable(activity);
        if (result != ConnectionResult.SUCCESS) {
            if (googleAPI.isUserResolvableError(result)) {
                googleAPI.getErrorDialog(activity, result,
                        PLAY_SERVICES_RESOLUTION_REQUEST).show();
            }
            return false;
        }
        return true;
    }
}
