package tookan.tookanlocationtrackinglibrary.retrofit2;

import android.content.Context;

import tookan.tookanlocationtrackinglibrary.metering.Keys;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;


/**
 * Class to configure the App in various modes
 */
public class Config
{


	/**
	 * Method to return default app mode
	 *
	 * @return
	 */
	private static AppMode getDefaultAppMode()
	{

		return AppMode.TEST;
	}

	/**
	 * Method tell whether the Build is release or not
	 *
	 * @return
	 */
	public static boolean isRelease()
	{

		return getDefaultAppMode() != AppMode.DEV;
	}

	/**
	 * Method to retrieve last saved AppMode
	 *
	 * @param context
	 * @return
	 */
	public static AppMode getCurrentAppMode(Context context)
	{

		AppMode appMode;

		if (isRelease()) appMode = getDefaultAppMode();
		else appMode = getAppMode(context);

		setAppMode(context, appMode.name());

		return appMode;
	}

	/**
	 * Method to retrieve last saved AppMode
	 *
	 * @param context
	 * @return
	 */
	public static String getServerUrl(Context context)
	{
		return getCurrentAppMode(context).serverUrl;
	}

	/**
	 * Method to retrieve last saved AppMode
	 *
	 * @param context
	 * @return
	 */
	public static String getMqttServerUrl(Context context)
	{
		return getCurrentAppMode(context).mqttServerUrl;
	}

	/**
	 * Method to save the App Mode
	 *
	 * @param context
	 * @param appModeName
	 */
	public static void setAppMode(Context context, String appModeName)
	{
		Prefs.with(context).save(Keys.Prefs.APP_MODE, appModeName);
	}

	/**
	 * Method to return app mode
	 *
	 * @return
	 */
	public static AppMode getAppMode(Context context)
	{
		return AppMode.valueOf(getCurrentAppModeName(context));
	}

	/**
	 * Method to evaluate the Currently used AppMode
	 *
	 * @param context
	 * @return
	 */
	public static String getCurrentAppModeName(Context context)
	{
		return Prefs.with(context).getString(Keys.Prefs.APP_MODE, getDefaultAppMode().name());
	}

	/**
	 * Various Modes to specify the Server Url
	 * intended for the End User
	 */

	public enum AppMode
	{
		APP("https://api.tookanapp.com:8888/", "app"),                // https://api3.tookanapp.com/

		DEV("https://dev.tracking.tookan.io:3008/", "dev"),               // Used for Development purpose only

		TEST("https://test.tookanapp.com:5555/", "test"),             // Used for Testing purpose only

		TEMPORARY("http://52.90.238.106:8888/", "");             // Temporary Server


		private final String serverUrl;
		private final String mqttServerUrl;

		AppMode(String serverUrl, String mqttServerUrl)
		{
			this.serverUrl = serverUrl;
			this.mqttServerUrl = mqttServerUrl;
		}
	}

}