package tookan.tookanlocationtrackinglibrary.metering.utils;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.BatteryManager;
import android.util.Log;

import java.io.File;

/**
 *
 * Developer: Rishabh
 * Dated: 11/23/15.
 */
public class Utils {

	/**
	 * Compares two double values with epsilon precision
	 *
	 * @param d1 double value 1
	 * @param d2 double value 2
	 * @return 1 if d1 > d2,
	 * -1 if d1 < d2 &
	 * 0 if d1 == d2
	 */
	public static int compareDouble(double d1, double d2) {
		if (d1 == d2) {
			return 0;
		} else {
			double epsilon = 0.0000001;
			if ((d1 - d2) > epsilon) {
				return 1;
			} else if ((d1 - d2) < epsilon) {
				return -1;
			} else {
				return 0;
			}
		}
	}


	public static String getChronoTimeFromMillis(long elapsedTime) {
		long timeR = elapsedTime;
		int hR = (int) (timeR / 3600000);
		int mR = (int) (timeR - hR * 3600000) / 60000;
		int sR = (int) (timeR - hR * 3600000 - mR * 60000) / 1000;
		String hhR = hR < 10 ? "0" + hR : hR + "";
		String mmR = mR < 10 ? "0" + mR : mR + "";
		String ssR = sR < 10 ? "0" + sR : sR + "";
		return (hhR + ":" + mmR + ":" + ssR);
	}

	public static void deleteCache(Context context) {
		try {
			File dir = context.getCacheDir();
			if (dir != null && dir.isDirectory()) {
				deleteDir(dir);
			}
		} catch (Exception e) {
		}
	}

	public static boolean deleteDir(File dir) {
		if (dir != null && dir.isDirectory()) {
			String[] children = dir.list();
			for (int i = 0; i < children.length; i++) {
				boolean success = deleteDir(new File(dir, children[i]));
				if (!success) {
					return false;
				}
			}
		}

		return dir.delete();
	}

	/**
	 * Method to
	 *
	 * @param context
	 * @return
	 */
	public static int getBatteryLevel(Context context) {

		float batteryPercentage;

		try {

			IntentFilter iFilter = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
			Intent batteryStatus = context.registerReceiver(null, iFilter);

			if (batteryStatus == null)
				return -1;

			int level = batteryStatus.getIntExtra(BatteryManager.EXTRA_LEVEL, -1);
			int scale = batteryStatus.getIntExtra(BatteryManager.EXTRA_SCALE, -1);

			if (level < 0 || scale < 0)
				batteryPercentage = -1;

			else batteryPercentage = (level / (float) scale) * 100;

		} catch (Exception e) {

			batteryPercentage = -1;
		}

		return (int) batteryPercentage;
	}
	/**
	 * Method to check for Internet Connection Status
	 *
	 * @param context
	 * @return true, if data connectivity is enabled, false otherwise
	 */
	public static boolean isDeviceOnline(Context context) {

		boolean isConnected = false;

		try {

			ConnectivityManager connectivityManager = (ConnectivityManager) context
					.getSystemService(Context.CONNECTIVITY_SERVICE);

			NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
			isConnected = networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
			return isConnected;

		} catch (Exception e) {

			Log.v("Utils" + ":  Connectivity", e.toString());
		}

		return isConnected;
	}

}
