package tookan.tookanlocationtrackinglibrary.metering;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;

import tookan.tookanlocationtrackinglibrary.metering.datastructure.SPLabels;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;


public class MeteringService extends Service
{

	public static final int UPLOAD_PATH_PI_REQUEST_CODE = 112;
	public static final String UPLOAD_PATH = "com.mapmeter.UPLOAD_PATH";
	public static final long ALARM_REPEAT_INTERVAL = 30000;
	private static final String TAG = MeteringService.class.getSimpleName();

	private PowerManager.WakeLock pWakeLock;
	private int locationUpdateFrequency = 1;


	public MeteringService()
	{
		Log.e("MeteringService", " instance created");
	}

	public static GpsDistanceCalculator gpsInstance(Context context)
	{
		return GpsDistanceCalculator.getInstance(context,
				GpsDistanceCalculator.getTotalDistanceFromSP(context),
				GpsDistanceCalculator.getLastLocationTimeFromSP(context),
				GpsDistanceCalculator.getTotalHaversineDistanceFromSP(context));
	}

	@Override
	public IBinder onBind(Intent intent)
	{
		throw new UnsupportedOperationException("Not yet implemented");
	}

	@Override
	public void onCreate()
	{
	}

	@Override
	public void onStart(Intent intent, int startId)
	{

		Log.e(TAG, "onStart");

		PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
		pWakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "TOOKAN");
		pWakeLock.acquire();

		cancelAlarm();

		gpsInstance(this).start();
//        startUploadPathAlarm();
	}

	@Override
	public int onStartCommand(Intent intent, int flags, int startId)
	{

		Log.e(TAG, "onStartCommand");

		super.onStartCommand(intent, flags, startId);
		return Service.START_STICKY;
	}

	@Override
	public void onTaskRemoved(Intent rootIntent)
	{

		Log.e(TAG, "onTaskRemoved");

		restartServiceViaAlarm();
	}

//    public void startUploadPathAlarm() {
//
//        Log.e(TAG, "startUploadPathAlarm");
//
//
//        // check task is scheduled or not
//        boolean alarmUp = (PendingIntent.getBroadcast(this, UPLOAD_PATH_PI_REQUEST_CODE,
//                new Intent(this, PathUploadReceiver.class).setAction(UPLOAD_PATH),
//                PendingIntent.FLAG_NO_CREATE) != null);
//
//        if (alarmUp) {
//            cancelUploadPathAlarm();
//        }
//
//        Intent intent = new Intent(this, PathUploadReceiver.class);
//        intent.setAction(UPLOAD_PATH);
//        PendingIntent pendingIntent = PendingIntent.getBroadcast(this, UPLOAD_PATH_PI_REQUEST_CODE,
//                intent, PendingIntent.FLAG_UPDATE_CURRENT);
//
//        AlarmManager alarmManager = (AlarmManager) this.getSystemService(Context.ALARM_SERVICE);
//        alarmManager.setRepeating(AlarmManager.ELAPSED_REALTIME_WAKEUP, SystemClock.elapsedRealtime(),
//                locationUpdateFrequency * 1000, pendingIntent);
//    }
//
//    public void cancelUploadPathAlarm() {
//
//        Log.e(TAG, "cancelUploadPathAlarm");
//
//        Intent intent = new Intent(this, PathUploadReceiver.class);
//        intent.setAction(UPLOAD_PATH);
//        PendingIntent pendingIntent = PendingIntent.getBroadcast(this, UPLOAD_PATH_PI_REQUEST_CODE,
//                intent, PendingIntent.FLAG_UPDATE_CURRENT);
//        AlarmManager alarmManager = (AlarmManager) this.getSystemService(Activity.ALARM_SERVICE);
//        alarmManager.cancel(pendingIntent);
//        pendingIntent.cancel();
//    }

	public void restartServiceViaAlarm()
	{

		Log.e(TAG, "restartServiceViaAlarm");


		try
		{
			gpsInstance(this).saveState();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		try
		{
			String meteringState = DatabaseMM.getInstance(this).getMetringState();
			String meteringStateSp = Prefs.with(this).getString(SPLabels.METERING_STATE, DatabaseMM.OFF);
			if (!DatabaseMM.ON.equalsIgnoreCase(meteringState) && !DatabaseMM.ON.equalsIgnoreCase(meteringStateSp))
			{
				gpsInstance(this).stop();
				DatabaseMM.getInstance(this).deleteAllCurrentPathItems();
//                cancelUploadPathAlarm();
			}
			else
			{
				Intent restartService = new Intent(getApplicationContext(), this.getClass());
				restartService.setPackage(getPackageName());
				PendingIntent restartServicePI = PendingIntent.getService(getApplicationContext(), 1, restartService, PendingIntent.FLAG_ONE_SHOT);
				AlarmManager alarmService = (AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE);
				alarmService.set(AlarmManager.ELAPSED_REALTIME, SystemClock.elapsedRealtime() + 1000, restartServicePI);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public void cancelAlarm()
	{

		Log.e(TAG, "cancelAlarm");

		Intent restartService = new Intent(getApplicationContext(), this.getClass());
		restartService.setPackage(getPackageName());
		PendingIntent restartServicePI = PendingIntent.getService(getApplicationContext(), 1, restartService, PendingIntent.FLAG_ONE_SHOT);
		AlarmManager alarmService = (AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE);
		alarmService.cancel(restartServicePI);
	}

	@Override
	public void onDestroy()
	{

		Log.e(TAG, "onDestroy");

		// Release the CPU WakeLock, if acquired
		if (pWakeLock != null) pWakeLock.release();

		restartServiceViaAlarm();
	}
}
