package tookan.tookanlocationtrackinglibrary;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.util.Log;
import android.widget.Toast;

import java.io.Serializable;

import tookan.tookanlocationtrackinglibrary.location.LocationUtils;
import tookan.tookanlocationtrackinglibrary.metering.Keys;
import tookan.tookanlocationtrackinglibrary.metering.Meter;
import tookan.tookanlocationtrackinglibrary.metering.utils.Prefs;

/**
 * Created by cl-macmini-83 on 28/07/16.
 */
public class TookanLocationTrackingImpl extends TookanLocationTracking
{
	Meter meter;
	public static LocationTracker locationTracker;

	public TookanLocationTrackingImpl(Context context)
	{
		this.meter = new Meter(context);
		Prefs.with(context).save(Keys.AppLocation.HIT_IN_PROGRESS, false);
	}

	@Override
	public void startLocationTracking(Context context, LocationTracker listener)
	{
		locationTracker = listener;

		if (arePermissionsEnabled(context))
		{
			authenticateKeys(context, TookanLocationTracking.getAccessToken(context), TookanLocationTracking.getKey(context));
		}
	}

	@Override
	public void setLocationMode(Context context, int locationMode)
	{
		Prefs.with(context).save(Keys.Prefs.TOOKAN_LOCATION_MODE, locationMode);
	}


	@Override
	public void stopLocationTracking(Context context)
	{
		if (this.meter == null)
		{
			this.meter = new Meter(context);
		}
		this.meter.stop();
	}

	@Override
	public Location getCurrentLocation(Context context)
	{
		return LocationUtils.getLastLocation(context);
	}

	public static boolean arePermissionsEnabled(Context context)
	{
		if (Build.VERSION.SDK_INT < 23)
		{
			return true;
		}
		else if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == PackageManager.PERMISSION_GRANTED)
		{
			return true;
		}
		else
		{
			Toast.makeText(context, "Please enable location permissions.", Toast.LENGTH_SHORT).show();

			Log.w("Location sdk error", "Please verify permissions. Have you enabled the required permissions ? ACCESS_FINE_LOCATION permission not granted.");
			return false;
		}
	}

	public void authenticateKeys(final Context context, String accessToken, String key)
	{
		if (meter == null)
		{
			meter = new Meter(context);
		}

		meter.start();
	}

	public interface LocationTracker extends Serializable
	{
		public void onLocationChange(Location location);
	}
}
